// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model



class AcceptPageRequest private constructor(builder: BuilderImpl) {
    /**
     * The accept code is a 6-digit code used to acknowledge the page.
     */
    val acceptCode: String? = builder.acceptCode
    /**
     * An optional field that Incident Manager uses to ENFORCE
     * AcceptCode validation when acknowledging an page. Acknowledgement can occur by
     * replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode
     * validation causes Incident Manager to verify that the code entered by the user matches the
     * code sent by Incident Manager with the page.
     * Incident Manager can also IGNORE
     * AcceptCode validation. Ignoring AcceptCode validation causes
     * Incident Manager to accept any value entered for the AcceptCode.
     */
    val acceptCodeValidation: AcceptCodeValidation? = builder.acceptCodeValidation
    /**
     * The type indicates if the page was DELIVERED or READ.
     */
    val acceptType: AcceptType? = builder.acceptType
    /**
     * The ARN of the contact channel.
     */
    val contactChannelId: String? = builder.contactChannelId
    /**
     * Information provided by the user when the user acknowledges the page.
     */
    val note: String? = builder.note
    /**
     * The Amazon Resource Name (ARN) of the engagement to a contact channel.
     */
    val pageId: String? = builder.pageId

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): AcceptPageRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("AcceptPageRequest(")
        append("acceptCode=$acceptCode,")
        append("acceptCodeValidation=$acceptCodeValidation,")
        append("acceptType=$acceptType,")
        append("contactChannelId=$contactChannelId,")
        append("note=$note,")
        append("pageId=$pageId)")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceptCode?.hashCode() ?: 0
        result = 31 * result + (acceptCodeValidation?.hashCode() ?: 0)
        result = 31 * result + (acceptType?.hashCode() ?: 0)
        result = 31 * result + (contactChannelId?.hashCode() ?: 0)
        result = 31 * result + (note?.hashCode() ?: 0)
        result = 31 * result + (pageId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as AcceptPageRequest

        if (acceptCode != other.acceptCode) return false
        if (acceptCodeValidation != other.acceptCodeValidation) return false
        if (acceptType != other.acceptType) return false
        if (contactChannelId != other.contactChannelId) return false
        if (note != other.note) return false
        if (pageId != other.pageId) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): AcceptPageRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): AcceptPageRequest
        /**
         * The accept code is a 6-digit code used to acknowledge the page.
         */
        fun acceptCode(acceptCode: String): FluentBuilder
        /**
         * An optional field that Incident Manager uses to ENFORCE
         * AcceptCode validation when acknowledging an page. Acknowledgement can occur by
         * replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode
         * validation causes Incident Manager to verify that the code entered by the user matches the
         * code sent by Incident Manager with the page.
         * Incident Manager can also IGNORE
         * AcceptCode validation. Ignoring AcceptCode validation causes
         * Incident Manager to accept any value entered for the AcceptCode.
         */
        fun acceptCodeValidation(acceptCodeValidation: AcceptCodeValidation): FluentBuilder
        /**
         * The type indicates if the page was DELIVERED or READ.
         */
        fun acceptType(acceptType: AcceptType): FluentBuilder
        /**
         * The ARN of the contact channel.
         */
        fun contactChannelId(contactChannelId: String): FluentBuilder
        /**
         * Information provided by the user when the user acknowledges the page.
         */
        fun note(note: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the engagement to a contact channel.
         */
        fun pageId(pageId: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The accept code is a 6-digit code used to acknowledge the page.
         */
        var acceptCode: String?
        /**
         * An optional field that Incident Manager uses to ENFORCE
         * AcceptCode validation when acknowledging an page. Acknowledgement can occur by
         * replying to a page, or when entering the AcceptCode in the console. Enforcing AcceptCode
         * validation causes Incident Manager to verify that the code entered by the user matches the
         * code sent by Incident Manager with the page.
         * Incident Manager can also IGNORE
         * AcceptCode validation. Ignoring AcceptCode validation causes
         * Incident Manager to accept any value entered for the AcceptCode.
         */
        var acceptCodeValidation: AcceptCodeValidation?
        /**
         * The type indicates if the page was DELIVERED or READ.
         */
        var acceptType: AcceptType?
        /**
         * The ARN of the contact channel.
         */
        var contactChannelId: String?
        /**
         * Information provided by the user when the user acknowledges the page.
         */
        var note: String?
        /**
         * The Amazon Resource Name (ARN) of the engagement to a contact channel.
         */
        var pageId: String?

        fun build(): AcceptPageRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var acceptCode: String? = null
        override var acceptCodeValidation: AcceptCodeValidation? = null
        override var acceptType: AcceptType? = null
        override var contactChannelId: String? = null
        override var note: String? = null
        override var pageId: String? = null

        constructor(x: AcceptPageRequest) : this() {
            this.acceptCode = x.acceptCode
            this.acceptCodeValidation = x.acceptCodeValidation
            this.acceptType = x.acceptType
            this.contactChannelId = x.contactChannelId
            this.note = x.note
            this.pageId = x.pageId
        }

        override fun build(): AcceptPageRequest = AcceptPageRequest(this)
        override fun acceptCode(acceptCode: String): FluentBuilder = apply { this.acceptCode = acceptCode }
        override fun acceptCodeValidation(acceptCodeValidation: AcceptCodeValidation): FluentBuilder = apply { this.acceptCodeValidation = acceptCodeValidation }
        override fun acceptType(acceptType: AcceptType): FluentBuilder = apply { this.acceptType = acceptType }
        override fun contactChannelId(contactChannelId: String): FluentBuilder = apply { this.contactChannelId = contactChannelId }
        override fun note(note: String): FluentBuilder = apply { this.note = note }
        override fun pageId(pageId: String): FluentBuilder = apply { this.pageId = pageId }
    }
}
