// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.regions.RegionConfig
import aws.sdk.kotlin.services.ssmcontacts.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine

/**
 * Systems Manager Incident Manager is an incident management console designed to help users
 * mitigate and recover from incidents affecting their Amazon Web Services-hosted applications.
 * An incident is any unplanned interruption or reduction in quality of services.
 * Incident Manager increases incident resolution by notifying responders of impact,
 * highlighting relevant troubleshooting data, and providing collaboration tools to get
 * services back up and running. To achieve the primary goal of reducing the
 * time-to-resolution of critical incidents, Incident Manager automates response plans
 * and enables responder team escalation.
 */
interface SsmContactsClient : SdkClient {

    override val serviceName: String
        get() = "SSM Contacts"
    /**
     * SsmContactsClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): SsmContactsClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultSsmContactsClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, IdempotencyTokenConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        override val region: String? = builder.region
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            var idempotencyTokenProvider: IdempotencyTokenProvider?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun idempotencyTokenProvider(idempotencyTokenProvider: IdempotencyTokenProvider): FluentBuilder = apply { this.idempotencyTokenProvider = idempotencyTokenProvider }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * Used to acknowledge an engagement to a contact channel during an incident.
     */
    suspend fun acceptPage(input: AcceptPageRequest): AcceptPageResponse

    /**
     * Used to acknowledge an engagement to a contact channel during an incident.
     */
    suspend fun acceptPage(block: AcceptPageRequest.DslBuilder.() -> Unit) = acceptPage(AcceptPageRequest.builder().apply(block).build())

    /**
     * Activates a contact's contact channel. Incident Manager can't engage a contact until the
     * contact channel has been activated.
     */
    suspend fun activateContactChannel(input: ActivateContactChannelRequest): ActivateContactChannelResponse

    /**
     * Activates a contact's contact channel. Incident Manager can't engage a contact until the
     * contact channel has been activated.
     */
    suspend fun activateContactChannel(block: ActivateContactChannelRequest.DslBuilder.() -> Unit) = activateContactChannel(ActivateContactChannelRequest.builder().apply(block).build())

    /**
     * Contacts are either the contacts that Incident Manager engages during an incident or the
     * escalation plans that Incident Manager uses to engage contacts in phases during an
     * incident.
     */
    suspend fun createContact(input: CreateContactRequest): CreateContactResponse

    /**
     * Contacts are either the contacts that Incident Manager engages during an incident or the
     * escalation plans that Incident Manager uses to engage contacts in phases during an
     * incident.
     */
    suspend fun createContact(block: CreateContactRequest.DslBuilder.() -> Unit) = createContact(CreateContactRequest.builder().apply(block).build())

    /**
     * A contact channel is the method that Incident Manager uses to engage your contact.
     */
    suspend fun createContactChannel(input: CreateContactChannelRequest): CreateContactChannelResponse

    /**
     * A contact channel is the method that Incident Manager uses to engage your contact.
     */
    suspend fun createContactChannel(block: CreateContactChannelRequest.DslBuilder.() -> Unit) = createContactChannel(CreateContactChannelRequest.builder().apply(block).build())

    /**
     * To no longer receive Incident Manager engagements to a contact channel, you can deactivate
     * the channel.
     */
    suspend fun deactivateContactChannel(input: DeactivateContactChannelRequest): DeactivateContactChannelResponse

    /**
     * To no longer receive Incident Manager engagements to a contact channel, you can deactivate
     * the channel.
     */
    suspend fun deactivateContactChannel(block: DeactivateContactChannelRequest.DslBuilder.() -> Unit) = deactivateContactChannel(DeactivateContactChannelRequest.builder().apply(block).build())

    /**
     * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact
     * removes them from all escalation plans and related response plans. Deleting an escalation
     * plan removes it from all related response plans. You will have to recreate the contact and
     * its contact channels before you can use it again.
     */
    suspend fun deleteContact(input: DeleteContactRequest): DeleteContactResponse

    /**
     * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact
     * removes them from all escalation plans and related response plans. Deleting an escalation
     * plan removes it from all related response plans. You will have to recreate the contact and
     * its contact channels before you can use it again.
     */
    suspend fun deleteContact(block: DeleteContactRequest.DslBuilder.() -> Unit) = deleteContact(DeleteContactRequest.builder().apply(block).build())

    /**
     * To no longer receive engagements on a contact channel, you can delete the channel from a
     * contact. Deleting the contact channel removes it from the contact's engagement plan. If you
     * delete the only contact channel for a contact, you won't be able to engage that contact
     * during an incident.
     */
    suspend fun deleteContactChannel(input: DeleteContactChannelRequest): DeleteContactChannelResponse

    /**
     * To no longer receive engagements on a contact channel, you can delete the channel from a
     * contact. Deleting the contact channel removes it from the contact's engagement plan. If you
     * delete the only contact channel for a contact, you won't be able to engage that contact
     * during an incident.
     */
    suspend fun deleteContactChannel(block: DeleteContactChannelRequest.DslBuilder.() -> Unit) = deleteContactChannel(DeleteContactChannelRequest.builder().apply(block).build())

    /**
     * Incident Manager uses engagements to engage contacts and escalation plans during an incident.
     * Use this command to describe the engagement that occurred during an incident.
     */
    suspend fun describeEngagement(input: DescribeEngagementRequest): DescribeEngagementResponse

    /**
     * Incident Manager uses engagements to engage contacts and escalation plans during an incident.
     * Use this command to describe the engagement that occurred during an incident.
     */
    suspend fun describeEngagement(block: DescribeEngagementRequest.DslBuilder.() -> Unit) = describeEngagement(DescribeEngagementRequest.builder().apply(block).build())

    /**
     * Lists details of the engagement to a contact channel.
     */
    suspend fun describePage(input: DescribePageRequest): DescribePageResponse

    /**
     * Lists details of the engagement to a contact channel.
     */
    suspend fun describePage(block: DescribePageRequest.DslBuilder.() -> Unit) = describePage(DescribePageRequest.builder().apply(block).build())

    /**
     * Retrieves information about the specified contact or escalation plan.
     */
    suspend fun getContact(input: GetContactRequest): GetContactResponse

    /**
     * Retrieves information about the specified contact or escalation plan.
     */
    suspend fun getContact(block: GetContactRequest.DslBuilder.() -> Unit) = getContact(GetContactRequest.builder().apply(block).build())

    /**
     * List details about a specific contact channel.
     */
    suspend fun getContactChannel(input: GetContactChannelRequest): GetContactChannelResponse

    /**
     * List details about a specific contact channel.
     */
    suspend fun getContactChannel(block: GetContactChannelRequest.DslBuilder.() -> Unit) = getContactChannel(GetContactChannelRequest.builder().apply(block).build())

    /**
     * Retrieves the resource policies attached to the specified contact or escalation
     * plan.
     */
    suspend fun getContactPolicy(input: GetContactPolicyRequest): GetContactPolicyResponse

    /**
     * Retrieves the resource policies attached to the specified contact or escalation
     * plan.
     */
    suspend fun getContactPolicy(block: GetContactPolicyRequest.DslBuilder.() -> Unit) = getContactPolicy(GetContactPolicyRequest.builder().apply(block).build())

    /**
     * Lists all contact channels for the specified contact.
     */
    suspend fun listContactChannels(input: ListContactChannelsRequest): ListContactChannelsResponse

    /**
     * Lists all contact channels for the specified contact.
     */
    suspend fun listContactChannels(block: ListContactChannelsRequest.DslBuilder.() -> Unit) = listContactChannels(ListContactChannelsRequest.builder().apply(block).build())

    /**
     * Lists all contacts and escalation plans in Incident Manager.
     */
    suspend fun listContacts(input: ListContactsRequest): ListContactsResponse

    /**
     * Lists all contacts and escalation plans in Incident Manager.
     */
    suspend fun listContacts(block: ListContactsRequest.DslBuilder.() -> Unit) = listContacts(ListContactsRequest.builder().apply(block).build())

    /**
     * Lists all engagements that have happened in an incident.
     */
    suspend fun listEngagements(input: ListEngagementsRequest): ListEngagementsResponse

    /**
     * Lists all engagements that have happened in an incident.
     */
    suspend fun listEngagements(block: ListEngagementsRequest.DslBuilder.() -> Unit) = listEngagements(ListEngagementsRequest.builder().apply(block).build())

    /**
     * Lists all of the engagements to contact channels that have been acknowledged.
     */
    suspend fun listPageReceipts(input: ListPageReceiptsRequest): ListPageReceiptsResponse

    /**
     * Lists all of the engagements to contact channels that have been acknowledged.
     */
    suspend fun listPageReceipts(block: ListPageReceiptsRequest.DslBuilder.() -> Unit) = listPageReceipts(ListPageReceiptsRequest.builder().apply(block).build())

    /**
     * Lists the engagements to a contact's contact channels.
     */
    suspend fun listPagesByContact(input: ListPagesByContactRequest): ListPagesByContactResponse

    /**
     * Lists the engagements to a contact's contact channels.
     */
    suspend fun listPagesByContact(block: ListPagesByContactRequest.DslBuilder.() -> Unit) = listPagesByContact(ListPagesByContactRequest.builder().apply(block).build())

    /**
     * Lists the engagements to contact channels that occurred by engaging a contact.
     */
    suspend fun listPagesByEngagement(input: ListPagesByEngagementRequest): ListPagesByEngagementResponse

    /**
     * Lists the engagements to contact channels that occurred by engaging a contact.
     */
    suspend fun listPagesByEngagement(block: ListPagesByEngagementRequest.DslBuilder.() -> Unit) = listPagesByEngagement(ListPagesByEngagementRequest.builder().apply(block).build())

    /**
     * Lists the tags of an escalation plan or contact.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the tags of an escalation plan or contact.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Adds a resource to the specified contact or escalation plan.
     */
    suspend fun putContactPolicy(input: PutContactPolicyRequest): PutContactPolicyResponse

    /**
     * Adds a resource to the specified contact or escalation plan.
     */
    suspend fun putContactPolicy(block: PutContactPolicyRequest.DslBuilder.() -> Unit) = putContactPolicy(PutContactPolicyRequest.builder().apply(block).build())

    /**
     * Sends an activation code to a contact channel. The contact can use this code to activate
     * the contact channel in the console or with the ActivateChannel operation.
     * Incident Manager can't engage a contact channel until it has been activated.
     */
    suspend fun sendActivationCode(input: SendActivationCodeRequest): SendActivationCodeResponse

    /**
     * Sends an activation code to a contact channel. The contact can use this code to activate
     * the contact channel in the console or with the ActivateChannel operation.
     * Incident Manager can't engage a contact channel until it has been activated.
     */
    suspend fun sendActivationCode(block: SendActivationCodeRequest.DslBuilder.() -> Unit) = sendActivationCode(SendActivationCodeRequest.builder().apply(block).build())

    /**
     * Starts an engagement to a contact or escalation plan. The engagement engages each
     * contact specified in the incident.
     */
    suspend fun startEngagement(input: StartEngagementRequest): StartEngagementResponse

    /**
     * Starts an engagement to a contact or escalation plan. The engagement engages each
     * contact specified in the incident.
     */
    suspend fun startEngagement(block: StartEngagementRequest.DslBuilder.() -> Unit) = startEngagement(StartEngagementRequest.builder().apply(block).build())

    /**
     * Stops an engagement before it finishes the final stage of the escalation plan or
     * engagement plan. Further contacts aren't engaged.
     */
    suspend fun stopEngagement(input: StopEngagementRequest): StopEngagementResponse

    /**
     * Stops an engagement before it finishes the final stage of the escalation plan or
     * engagement plan. Further contacts aren't engaged.
     */
    suspend fun stopEngagement(block: StopEngagementRequest.DslBuilder.() -> Unit) = stopEngagement(StopEngagementRequest.builder().apply(block).build())

    /**
     * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the
     * first region of your replication set.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the
     * first region of your replication set.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes tags from the specified resource.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes tags from the specified resource.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates the contact or escalation plan specified.
     */
    suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse

    /**
     * Updates the contact or escalation plan specified.
     */
    suspend fun updateContact(block: UpdateContactRequest.DslBuilder.() -> Unit) = updateContact(UpdateContactRequest.builder().apply(block).build())

    /**
     * Updates a contact's contact channel.
     */
    suspend fun updateContactChannel(input: UpdateContactChannelRequest): UpdateContactChannelResponse

    /**
     * Updates a contact's contact channel.
     */
    suspend fun updateContactChannel(block: UpdateContactChannelRequest.DslBuilder.() -> Unit) = updateContactChannel(UpdateContactChannelRequest.builder().apply(block).build())
}
