// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.serde

import aws.sdk.kotlin.services.ssmcontacts.model.GetRotationOverrideResponse
import aws.sdk.kotlin.services.ssmcontacts.model.SsmContactsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class GetRotationOverrideOperationDeserializer: HttpDeserializer.NonStreaming<GetRotationOverrideResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetRotationOverrideResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRotationOverrideError(context, call, payload)
        }
        val builder = GetRotationOverrideResponse.Builder()

        if (payload != null) {
            deserializeGetRotationOverrideOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetRotationOverrideError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmContactsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmContactsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRotationOverrideOperationBody(builder: GetRotationOverrideResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreateTime"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val NEWCONTACTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NewContactIds"))
    val ROTATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RotationArn"))
    val ROTATIONOVERRIDEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RotationOverrideId"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATETIME_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(NEWCONTACTIDS_DESCRIPTOR)
        field(ROTATIONARN_DESCRIPTOR)
        field(ROTATIONOVERRIDEID_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                NEWCONTACTIDS_DESCRIPTOR.index -> builder.newContactIds =
                    deserializer.deserializeList(NEWCONTACTIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROTATIONARN_DESCRIPTOR.index -> builder.rotationArn = deserializeString()
                ROTATIONOVERRIDEID_DESCRIPTOR.index -> builder.rotationOverrideId = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
