// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about when an on-call rotation is in effect and how long the rotation period lasts.
 */
public class RecurrenceSettings private constructor(builder: Builder) {
    /**
     * Information about on-call rotations that recur daily.
     */
    public val dailySettings: List<HandOffTime>? = builder.dailySettings
    /**
     * Information about on-call rotations that recur monthly.
     */
    public val monthlySettings: List<MonthlySetting>? = builder.monthlySettings
    /**
     * The number of contacts, or shift team members designated to be on call concurrently during a shift. For example, in an on-call schedule containing ten contacts, a value of `2` designates that two of them are on call at any given time.
     */
    public val numberOfOnCalls: kotlin.Int = requireNotNull(builder.numberOfOnCalls) { "A non-null value must be provided for numberOfOnCalls" }
    /**
     * The number of days, weeks, or months a single rotation lasts.
     */
    public val recurrenceMultiplier: kotlin.Int = requireNotNull(builder.recurrenceMultiplier) { "A non-null value must be provided for recurrenceMultiplier" }
    /**
     * Information about the days of the week included in on-call rotation coverage.
     */
    public val shiftCoverages: Map<DayOfWeek, List<CoverageTime>>? = builder.shiftCoverages
    /**
     * Information about on-call rotations that recur weekly.
     */
    public val weeklySettings: List<WeeklySetting>? = builder.weeklySettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RecurrenceSettings(")
        append("dailySettings=$dailySettings,")
        append("monthlySettings=$monthlySettings,")
        append("numberOfOnCalls=$numberOfOnCalls,")
        append("recurrenceMultiplier=$recurrenceMultiplier,")
        append("shiftCoverages=$shiftCoverages,")
        append("weeklySettings=$weeklySettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dailySettings?.hashCode() ?: 0
        result = 31 * result + (monthlySettings?.hashCode() ?: 0)
        result = 31 * result + (numberOfOnCalls)
        result = 31 * result + (recurrenceMultiplier)
        result = 31 * result + (shiftCoverages?.hashCode() ?: 0)
        result = 31 * result + (weeklySettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RecurrenceSettings

        if (dailySettings != other.dailySettings) return false
        if (monthlySettings != other.monthlySettings) return false
        if (numberOfOnCalls != other.numberOfOnCalls) return false
        if (recurrenceMultiplier != other.recurrenceMultiplier) return false
        if (shiftCoverages != other.shiftCoverages) return false
        if (weeklySettings != other.weeklySettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Information about on-call rotations that recur daily.
         */
        public var dailySettings: List<HandOffTime>? = null
        /**
         * Information about on-call rotations that recur monthly.
         */
        public var monthlySettings: List<MonthlySetting>? = null
        /**
         * The number of contacts, or shift team members designated to be on call concurrently during a shift. For example, in an on-call schedule containing ten contacts, a value of `2` designates that two of them are on call at any given time.
         */
        public var numberOfOnCalls: kotlin.Int? = null
        /**
         * The number of days, weeks, or months a single rotation lasts.
         */
        public var recurrenceMultiplier: kotlin.Int? = null
        /**
         * Information about the days of the week included in on-call rotation coverage.
         */
        public var shiftCoverages: Map<DayOfWeek, List<CoverageTime>>? = null
        /**
         * Information about on-call rotations that recur weekly.
         */
        public var weeklySettings: List<WeeklySetting>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings) : this() {
            this.dailySettings = x.dailySettings
            this.monthlySettings = x.monthlySettings
            this.numberOfOnCalls = x.numberOfOnCalls
            this.recurrenceMultiplier = x.recurrenceMultiplier
            this.shiftCoverages = x.shiftCoverages
            this.weeklySettings = x.weeklySettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings = RecurrenceSettings(this)

        internal fun correctErrors(): Builder {
            if (numberOfOnCalls == null) numberOfOnCalls = 0
            if (recurrenceMultiplier == null) recurrenceMultiplier = 0
            return this
        }
    }
}
