// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateContactChannelRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
     */
    public val contactId: kotlin.String? = builder.contactId
    /**
     * If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.
     */
    public val deferActivation: kotlin.Boolean? = builder.deferActivation
    /**
     * The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:
     * + SMS - '+' followed by the country code and phone number
     * + VOICE - '+' followed by the country code and phone number
     * + EMAIL - any standard email format
     */
    public val deliveryAddress: aws.sdk.kotlin.services.ssmcontacts.model.ContactChannelAddress? = builder.deliveryAddress
    /**
     * A token ensuring that the operation is called only once with the specified details.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The name of the contact channel.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Incident Manager supports three types of contact channels:
     * + `SMS`
     * + `VOICE`
     * + `EMAIL`
     */
    public val type: aws.sdk.kotlin.services.ssmcontacts.model.ChannelType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.CreateContactChannelRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateContactChannelRequest(")
        append("contactId=$contactId,")
        append("deferActivation=$deferActivation,")
        append("deliveryAddress=$deliveryAddress,")
        append("idempotencyToken=$idempotencyToken,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactId?.hashCode() ?: 0
        result = 31 * result + (deferActivation?.hashCode() ?: 0)
        result = 31 * result + (deliveryAddress?.hashCode() ?: 0)
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateContactChannelRequest

        if (contactId != other.contactId) return false
        if (deferActivation != other.deferActivation) return false
        if (deliveryAddress != other.deliveryAddress) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.CreateContactChannelRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the contact you are adding the contact channel to.
         */
        public var contactId: kotlin.String? = null
        /**
         * If you want to activate the channel at a later time, you can choose to defer activation. Incident Manager can't engage your contact channel until it has been activated.
         */
        public var deferActivation: kotlin.Boolean? = null
        /**
         * The details that Incident Manager uses when trying to engage the contact channel. The format is dependent on the type of the contact channel. The following are the expected formats:
         * + SMS - '+' followed by the country code and phone number
         * + VOICE - '+' followed by the country code and phone number
         * + EMAIL - any standard email format
         */
        public var deliveryAddress: aws.sdk.kotlin.services.ssmcontacts.model.ContactChannelAddress? = null
        /**
         * A token ensuring that the operation is called only once with the specified details.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The name of the contact channel.
         */
        public var name: kotlin.String? = null
        /**
         * Incident Manager supports three types of contact channels:
         * + `SMS`
         * + `VOICE`
         * + `EMAIL`
         */
        public var type: aws.sdk.kotlin.services.ssmcontacts.model.ChannelType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.CreateContactChannelRequest) : this() {
            this.contactId = x.contactId
            this.deferActivation = x.deferActivation
            this.deliveryAddress = x.deliveryAddress
            this.idempotencyToken = x.idempotencyToken
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.CreateContactChannelRequest = CreateContactChannelRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssmcontacts.model.ContactChannelAddress] inside the given [block]
         */
        public fun deliveryAddress(block: aws.sdk.kotlin.services.ssmcontacts.model.ContactChannelAddress.Builder.() -> kotlin.Unit) {
            this.deliveryAddress = aws.sdk.kotlin.services.ssmcontacts.model.ContactChannelAddress.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
