// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.ssmcontacts.auth.DefaultSsmContactsAuthSchemeProvider
import aws.sdk.kotlin.services.ssmcontacts.auth.SsmContactsAuthSchemeProvider
import aws.sdk.kotlin.services.ssmcontacts.endpoints.DefaultSsmContactsEndpointProvider
import aws.sdk.kotlin.services.ssmcontacts.endpoints.SsmContactsEndpointParameters
import aws.sdk.kotlin.services.ssmcontacts.endpoints.SsmContactsEndpointProvider
import aws.sdk.kotlin.services.ssmcontacts.model.AcceptPageRequest
import aws.sdk.kotlin.services.ssmcontacts.model.AcceptPageResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ActivateContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ActivateContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.CreateContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.CreateContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.CreateContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.CreateContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.CreateRotationOverrideRequest
import aws.sdk.kotlin.services.ssmcontacts.model.CreateRotationOverrideResponse
import aws.sdk.kotlin.services.ssmcontacts.model.CreateRotationRequest
import aws.sdk.kotlin.services.ssmcontacts.model.CreateRotationResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DeactivateContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DeactivateContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteRotationOverrideRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteRotationOverrideResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteRotationRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteRotationResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DescribeEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DescribeEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DescribePageRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DescribePageResponse
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactPolicyRequest
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactPolicyResponse
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.GetRotationOverrideRequest
import aws.sdk.kotlin.services.ssmcontacts.model.GetRotationOverrideResponse
import aws.sdk.kotlin.services.ssmcontacts.model.GetRotationRequest
import aws.sdk.kotlin.services.ssmcontacts.model.GetRotationResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactChannelsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactChannelsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListEngagementsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListEngagementsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPageReceiptsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPageReceiptsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPageResolutionsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPageResolutionsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPreviewRotationShiftsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPreviewRotationShiftsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListRotationOverridesRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListRotationOverridesResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListRotationShiftsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListRotationShiftsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListRotationsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListRotationsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ssmcontacts.model.PutContactPolicyRequest
import aws.sdk.kotlin.services.ssmcontacts.model.PutContactPolicyResponse
import aws.sdk.kotlin.services.ssmcontacts.model.SendActivationCodeRequest
import aws.sdk.kotlin.services.ssmcontacts.model.SendActivationCodeResponse
import aws.sdk.kotlin.services.ssmcontacts.model.StartEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.StartEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.StopEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.StopEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.TagResourceRequest
import aws.sdk.kotlin.services.ssmcontacts.model.TagResourceResponse
import aws.sdk.kotlin.services.ssmcontacts.model.UntagResourceRequest
import aws.sdk.kotlin.services.ssmcontacts.model.UntagResourceResponse
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateRotationRequest
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateRotationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "SSM Contacts"
public const val SdkVersion: String = "1.3.9"
public const val ServiceApiVersion: String = "2021-05-03"

/**
 * Systems Manager Incident Manager is an incident management console designed to help users mitigate and recover from incidents affecting their Amazon Web Services-hosted applications. An incident is any unplanned interruption or reduction in quality of services.
 *
 * Incident Manager increases incident resolution by notifying responders of impact, highlighting relevant troubleshooting data, and providing collaboration tools to get services back up and running. To achieve the primary goal of reducing the time-to-resolution of critical incidents, Incident Manager automates response plans and enables responder team escalation.
 */
public interface SsmContactsClient : SdkClient {
    /**
     * SsmContactsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, SsmContactsClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "SsmContacts",
                "SSM_CONTACTS",
                "ssm_contacts",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, SsmContactsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): SsmContactsClient = DefaultSsmContactsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: SsmContactsEndpointProvider = builder.endpointProvider ?: DefaultSsmContactsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: SsmContactsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultSsmContactsAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "SSM Contacts"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: SsmContactsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: SsmContactsAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Used to acknowledge an engagement to a contact channel during an incident.
     */
    public suspend fun acceptPage(input: AcceptPageRequest): AcceptPageResponse

    /**
     * Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been activated.
     */
    public suspend fun activateContactChannel(input: ActivateContactChannelRequest): ActivateContactChannelResponse

    /**
     * Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident.
     */
    public suspend fun createContact(input: CreateContactRequest): CreateContactResponse

    /**
     * A contact channel is the method that Incident Manager uses to engage your contact.
     */
    public suspend fun createContactChannel(input: CreateContactChannelRequest): CreateContactChannelResponse

    /**
     * Creates a rotation in an on-call schedule.
     */
    public suspend fun createRotation(input: CreateRotationRequest): CreateRotationResponse

    /**
     * Creates an override for a rotation in an on-call schedule.
     */
    public suspend fun createRotationOverride(input: CreateRotationOverrideRequest): CreateRotationOverrideResponse

    /**
     * To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.
     */
    public suspend fun deactivateContactChannel(input: DeactivateContactChannelRequest): DeactivateContactChannelResponse

    /**
     * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all escalation plans and related response plans. Deleting an escalation plan removes it from all related response plans. You will have to recreate the contact and its contact channels before you can use it again.
     */
    public suspend fun deleteContact(input: DeleteContactRequest): DeleteContactResponse

    /**
     * To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a contact, you won't be able to engage that contact during an incident.
     */
    public suspend fun deleteContactChannel(input: DeleteContactChannelRequest): DeleteContactChannelResponse

    /**
     * Deletes a rotation from the system. If a rotation belongs to more than one on-call schedule, this operation deletes it from all of them.
     */
    public suspend fun deleteRotation(input: DeleteRotationRequest): DeleteRotationResponse

    /**
     * Deletes an existing override for an on-call rotation.
     */
    public suspend fun deleteRotationOverride(input: DeleteRotationOverrideRequest): DeleteRotationOverrideResponse

    /**
     * Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to describe the engagement that occurred during an incident.
     */
    public suspend fun describeEngagement(input: DescribeEngagementRequest): DescribeEngagementResponse

    /**
     * Lists details of the engagement to a contact channel.
     */
    public suspend fun describePage(input: DescribePageRequest): DescribePageResponse

    /**
     * Retrieves information about the specified contact or escalation plan.
     */
    public suspend fun getContact(input: GetContactRequest): GetContactResponse

    /**
     * List details about a specific contact channel.
     */
    public suspend fun getContactChannel(input: GetContactChannelRequest): GetContactChannelResponse

    /**
     * Retrieves the resource policies attached to the specified contact or escalation plan.
     */
    public suspend fun getContactPolicy(input: GetContactPolicyRequest): GetContactPolicyResponse

    /**
     * Retrieves information about an on-call rotation.
     */
    public suspend fun getRotation(input: GetRotationRequest): GetRotationResponse

    /**
     * Retrieves information about an override to an on-call rotation.
     */
    public suspend fun getRotationOverride(input: GetRotationOverrideRequest): GetRotationOverrideResponse

    /**
     * Lists all contact channels for the specified contact.
     */
    public suspend fun listContactChannels(input: ListContactChannelsRequest): ListContactChannelsResponse

    /**
     * Lists all contacts and escalation plans in Incident Manager.
     */
    public suspend fun listContacts(input: ListContactsRequest = ListContactsRequest { }): ListContactsResponse

    /**
     * Lists all engagements that have happened in an incident.
     */
    public suspend fun listEngagements(input: ListEngagementsRequest = ListEngagementsRequest { }): ListEngagementsResponse

    /**
     * Lists all of the engagements to contact channels that have been acknowledged.
     */
    public suspend fun listPageReceipts(input: ListPageReceiptsRequest): ListPageReceiptsResponse

    /**
     * Returns the resolution path of an engagement. For example, the escalation plan engaged in an incident might target an on-call schedule that includes several contacts in a rotation, but just one contact on-call when the incident starts. The resolution path indicates the hierarchy of *escalation plan > on-call schedule > contact*.
     */
    public suspend fun listPageResolutions(input: ListPageResolutionsRequest): ListPageResolutionsResponse

    /**
     * Lists the engagements to a contact's contact channels.
     */
    public suspend fun listPagesByContact(input: ListPagesByContactRequest): ListPagesByContactResponse

    /**
     * Lists the engagements to contact channels that occurred by engaging a contact.
     */
    public suspend fun listPagesByEngagement(input: ListPagesByEngagementRequest): ListPagesByEngagementResponse

    /**
     * Returns a list of shifts based on rotation configuration parameters.
     *
     * The Incident Manager primarily uses this operation to populate the **Preview** calendar. It is not typically run by end users.
     */
    public suspend fun listPreviewRotationShifts(input: ListPreviewRotationShiftsRequest): ListPreviewRotationShiftsResponse

    /**
     * Retrieves a list of overrides currently specified for an on-call rotation.
     */
    public suspend fun listRotationOverrides(input: ListRotationOverridesRequest): ListRotationOverridesResponse

    /**
     * Returns a list of shifts generated by an existing rotation in the system.
     */
    public suspend fun listRotationShifts(input: ListRotationShiftsRequest): ListRotationShiftsResponse

    /**
     * Retrieves a list of on-call rotations.
     */
    public suspend fun listRotations(input: ListRotationsRequest = ListRotationsRequest { }): ListRotationsResponse

    /**
     * Lists the tags of an escalation plan or contact.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds a resource policy to the specified contact or escalation plan. The resource policy is used to share the contact or escalation plan using Resource Access Manager (RAM). For more information about cross-account sharing, see [Setting up cross-account functionality](https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html).
     */
    public suspend fun putContactPolicy(input: PutContactPolicyRequest): PutContactPolicyResponse

    /**
     * Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in the console or with the `ActivateChannel` operation. Incident Manager can't engage a contact channel until it has been activated.
     */
    public suspend fun sendActivationCode(input: SendActivationCodeRequest): SendActivationCodeResponse

    /**
     * Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.
     */
    public suspend fun startEngagement(input: StartEngagementRequest): StartEngagementResponse

    /**
     * Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further contacts aren't engaged.
     */
    public suspend fun stopEngagement(input: StopEngagementRequest): StopEngagementResponse

    /**
     * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your replication set.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the contact or escalation plan specified.
     */
    public suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse

    /**
     * Updates a contact's contact channel.
     */
    public suspend fun updateContactChannel(input: UpdateContactChannelRequest): UpdateContactChannelResponse

    /**
     * Updates the information specified for an on-call rotation.
     */
    public suspend fun updateRotation(input: UpdateRotationRequest): UpdateRotationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun SsmContactsClient.withConfig(block: SsmContactsClient.Config.Builder.() -> Unit): SsmContactsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultSsmContactsClient(newConfig)
}

/**
 * Used to acknowledge an engagement to a contact channel during an incident.
 */
public suspend inline fun SsmContactsClient.acceptPage(crossinline block: AcceptPageRequest.Builder.() -> Unit): AcceptPageResponse = acceptPage(AcceptPageRequest.Builder().apply(block).build())

/**
 * Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been activated.
 */
public suspend inline fun SsmContactsClient.activateContactChannel(crossinline block: ActivateContactChannelRequest.Builder.() -> Unit): ActivateContactChannelResponse = activateContactChannel(ActivateContactChannelRequest.Builder().apply(block).build())

/**
 * Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident.
 */
public suspend inline fun SsmContactsClient.createContact(crossinline block: CreateContactRequest.Builder.() -> Unit): CreateContactResponse = createContact(CreateContactRequest.Builder().apply(block).build())

/**
 * A contact channel is the method that Incident Manager uses to engage your contact.
 */
public suspend inline fun SsmContactsClient.createContactChannel(crossinline block: CreateContactChannelRequest.Builder.() -> Unit): CreateContactChannelResponse = createContactChannel(CreateContactChannelRequest.Builder().apply(block).build())

/**
 * Creates a rotation in an on-call schedule.
 */
public suspend inline fun SsmContactsClient.createRotation(crossinline block: CreateRotationRequest.Builder.() -> Unit): CreateRotationResponse = createRotation(CreateRotationRequest.Builder().apply(block).build())

/**
 * Creates an override for a rotation in an on-call schedule.
 */
public suspend inline fun SsmContactsClient.createRotationOverride(crossinline block: CreateRotationOverrideRequest.Builder.() -> Unit): CreateRotationOverrideResponse = createRotationOverride(CreateRotationOverrideRequest.Builder().apply(block).build())

/**
 * To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.
 */
public suspend inline fun SsmContactsClient.deactivateContactChannel(crossinline block: DeactivateContactChannelRequest.Builder.() -> Unit): DeactivateContactChannelResponse = deactivateContactChannel(DeactivateContactChannelRequest.Builder().apply(block).build())

/**
 * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all escalation plans and related response plans. Deleting an escalation plan removes it from all related response plans. You will have to recreate the contact and its contact channels before you can use it again.
 */
public suspend inline fun SsmContactsClient.deleteContact(crossinline block: DeleteContactRequest.Builder.() -> Unit): DeleteContactResponse = deleteContact(DeleteContactRequest.Builder().apply(block).build())

/**
 * To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a contact, you won't be able to engage that contact during an incident.
 */
public suspend inline fun SsmContactsClient.deleteContactChannel(crossinline block: DeleteContactChannelRequest.Builder.() -> Unit): DeleteContactChannelResponse = deleteContactChannel(DeleteContactChannelRequest.Builder().apply(block).build())

/**
 * Deletes a rotation from the system. If a rotation belongs to more than one on-call schedule, this operation deletes it from all of them.
 */
public suspend inline fun SsmContactsClient.deleteRotation(crossinline block: DeleteRotationRequest.Builder.() -> Unit): DeleteRotationResponse = deleteRotation(DeleteRotationRequest.Builder().apply(block).build())

/**
 * Deletes an existing override for an on-call rotation.
 */
public suspend inline fun SsmContactsClient.deleteRotationOverride(crossinline block: DeleteRotationOverrideRequest.Builder.() -> Unit): DeleteRotationOverrideResponse = deleteRotationOverride(DeleteRotationOverrideRequest.Builder().apply(block).build())

/**
 * Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to describe the engagement that occurred during an incident.
 */
public suspend inline fun SsmContactsClient.describeEngagement(crossinline block: DescribeEngagementRequest.Builder.() -> Unit): DescribeEngagementResponse = describeEngagement(DescribeEngagementRequest.Builder().apply(block).build())

/**
 * Lists details of the engagement to a contact channel.
 */
public suspend inline fun SsmContactsClient.describePage(crossinline block: DescribePageRequest.Builder.() -> Unit): DescribePageResponse = describePage(DescribePageRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified contact or escalation plan.
 */
public suspend inline fun SsmContactsClient.getContact(crossinline block: GetContactRequest.Builder.() -> Unit): GetContactResponse = getContact(GetContactRequest.Builder().apply(block).build())

/**
 * List details about a specific contact channel.
 */
public suspend inline fun SsmContactsClient.getContactChannel(crossinline block: GetContactChannelRequest.Builder.() -> Unit): GetContactChannelResponse = getContactChannel(GetContactChannelRequest.Builder().apply(block).build())

/**
 * Retrieves the resource policies attached to the specified contact or escalation plan.
 */
public suspend inline fun SsmContactsClient.getContactPolicy(crossinline block: GetContactPolicyRequest.Builder.() -> Unit): GetContactPolicyResponse = getContactPolicy(GetContactPolicyRequest.Builder().apply(block).build())

/**
 * Retrieves information about an on-call rotation.
 */
public suspend inline fun SsmContactsClient.getRotation(crossinline block: GetRotationRequest.Builder.() -> Unit): GetRotationResponse = getRotation(GetRotationRequest.Builder().apply(block).build())

/**
 * Retrieves information about an override to an on-call rotation.
 */
public suspend inline fun SsmContactsClient.getRotationOverride(crossinline block: GetRotationOverrideRequest.Builder.() -> Unit): GetRotationOverrideResponse = getRotationOverride(GetRotationOverrideRequest.Builder().apply(block).build())

/**
 * Lists all contact channels for the specified contact.
 */
public suspend inline fun SsmContactsClient.listContactChannels(crossinline block: ListContactChannelsRequest.Builder.() -> Unit): ListContactChannelsResponse = listContactChannels(ListContactChannelsRequest.Builder().apply(block).build())

/**
 * Lists all contacts and escalation plans in Incident Manager.
 */
public suspend inline fun SsmContactsClient.listContacts(crossinline block: ListContactsRequest.Builder.() -> Unit): ListContactsResponse = listContacts(ListContactsRequest.Builder().apply(block).build())

/**
 * Lists all engagements that have happened in an incident.
 */
public suspend inline fun SsmContactsClient.listEngagements(crossinline block: ListEngagementsRequest.Builder.() -> Unit): ListEngagementsResponse = listEngagements(ListEngagementsRequest.Builder().apply(block).build())

/**
 * Lists all of the engagements to contact channels that have been acknowledged.
 */
public suspend inline fun SsmContactsClient.listPageReceipts(crossinline block: ListPageReceiptsRequest.Builder.() -> Unit): ListPageReceiptsResponse = listPageReceipts(ListPageReceiptsRequest.Builder().apply(block).build())

/**
 * Returns the resolution path of an engagement. For example, the escalation plan engaged in an incident might target an on-call schedule that includes several contacts in a rotation, but just one contact on-call when the incident starts. The resolution path indicates the hierarchy of *escalation plan > on-call schedule > contact*.
 */
public suspend inline fun SsmContactsClient.listPageResolutions(crossinline block: ListPageResolutionsRequest.Builder.() -> Unit): ListPageResolutionsResponse = listPageResolutions(ListPageResolutionsRequest.Builder().apply(block).build())

/**
 * Lists the engagements to a contact's contact channels.
 */
public suspend inline fun SsmContactsClient.listPagesByContact(crossinline block: ListPagesByContactRequest.Builder.() -> Unit): ListPagesByContactResponse = listPagesByContact(ListPagesByContactRequest.Builder().apply(block).build())

/**
 * Lists the engagements to contact channels that occurred by engaging a contact.
 */
public suspend inline fun SsmContactsClient.listPagesByEngagement(crossinline block: ListPagesByEngagementRequest.Builder.() -> Unit): ListPagesByEngagementResponse = listPagesByEngagement(ListPagesByEngagementRequest.Builder().apply(block).build())

/**
 * Returns a list of shifts based on rotation configuration parameters.
 *
 * The Incident Manager primarily uses this operation to populate the **Preview** calendar. It is not typically run by end users.
 */
public suspend inline fun SsmContactsClient.listPreviewRotationShifts(crossinline block: ListPreviewRotationShiftsRequest.Builder.() -> Unit): ListPreviewRotationShiftsResponse = listPreviewRotationShifts(ListPreviewRotationShiftsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of overrides currently specified for an on-call rotation.
 */
public suspend inline fun SsmContactsClient.listRotationOverrides(crossinline block: ListRotationOverridesRequest.Builder.() -> Unit): ListRotationOverridesResponse = listRotationOverrides(ListRotationOverridesRequest.Builder().apply(block).build())

/**
 * Returns a list of shifts generated by an existing rotation in the system.
 */
public suspend inline fun SsmContactsClient.listRotationShifts(crossinline block: ListRotationShiftsRequest.Builder.() -> Unit): ListRotationShiftsResponse = listRotationShifts(ListRotationShiftsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of on-call rotations.
 */
public suspend inline fun SsmContactsClient.listRotations(crossinline block: ListRotationsRequest.Builder.() -> Unit): ListRotationsResponse = listRotations(ListRotationsRequest.Builder().apply(block).build())

/**
 * Lists the tags of an escalation plan or contact.
 */
public suspend inline fun SsmContactsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds a resource policy to the specified contact or escalation plan. The resource policy is used to share the contact or escalation plan using Resource Access Manager (RAM). For more information about cross-account sharing, see [Setting up cross-account functionality](https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html).
 */
public suspend inline fun SsmContactsClient.putContactPolicy(crossinline block: PutContactPolicyRequest.Builder.() -> Unit): PutContactPolicyResponse = putContactPolicy(PutContactPolicyRequest.Builder().apply(block).build())

/**
 * Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in the console or with the `ActivateChannel` operation. Incident Manager can't engage a contact channel until it has been activated.
 */
public suspend inline fun SsmContactsClient.sendActivationCode(crossinline block: SendActivationCodeRequest.Builder.() -> Unit): SendActivationCodeResponse = sendActivationCode(SendActivationCodeRequest.Builder().apply(block).build())

/**
 * Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.
 */
public suspend inline fun SsmContactsClient.startEngagement(crossinline block: StartEngagementRequest.Builder.() -> Unit): StartEngagementResponse = startEngagement(StartEngagementRequest.Builder().apply(block).build())

/**
 * Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further contacts aren't engaged.
 */
public suspend inline fun SsmContactsClient.stopEngagement(crossinline block: StopEngagementRequest.Builder.() -> Unit): StopEngagementResponse = stopEngagement(StopEngagementRequest.Builder().apply(block).build())

/**
 * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your replication set.
 */
public suspend inline fun SsmContactsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified resource.
 */
public suspend inline fun SsmContactsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the contact or escalation plan specified.
 */
public suspend inline fun SsmContactsClient.updateContact(crossinline block: UpdateContactRequest.Builder.() -> Unit): UpdateContactResponse = updateContact(UpdateContactRequest.Builder().apply(block).build())

/**
 * Updates a contact's contact channel.
 */
public suspend inline fun SsmContactsClient.updateContactChannel(crossinline block: UpdateContactChannelRequest.Builder.() -> Unit): UpdateContactChannelResponse = updateContactChannel(UpdateContactChannelRequest.Builder().apply(block).build())

/**
 * Updates the information specified for an on-call rotation.
 */
public suspend inline fun SsmContactsClient.updateRotation(crossinline block: UpdateRotationRequest.Builder.() -> Unit): UpdateRotationResponse = updateRotation(UpdateRotationRequest.Builder().apply(block).build())
