// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.serde

import aws.sdk.kotlin.services.ssmcontacts.model.DescribePageResponse
import aws.sdk.kotlin.services.ssmcontacts.model.SsmContactsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class DescribePageOperationDeserializer: HttpDeserializer.NonStreaming<DescribePageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribePageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribePageError(context, call, payload)
        }
        val builder = DescribePageResponse.Builder()

        if (payload != null) {
            deserializeDescribePageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribePageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmContactsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "DataEncryptionException" -> DataEncryptionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmContactsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePageOperationBody(builder: DescribePageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactArn"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Content"))
    val DELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DeliveryTime"))
    val ENGAGEMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EngagementArn"))
    val INCIDENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IncidentId"))
    val PAGEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PageArn"))
    val PUBLICCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PublicContent"))
    val PUBLICSUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PublicSubject"))
    val READTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ReadTime"))
    val SENDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Sender"))
    val SENTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("SentTime"))
    val SUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Subject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTARN_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(DELIVERYTIME_DESCRIPTOR)
        field(ENGAGEMENTARN_DESCRIPTOR)
        field(INCIDENTID_DESCRIPTOR)
        field(PAGEARN_DESCRIPTOR)
        field(PUBLICCONTENT_DESCRIPTOR)
        field(PUBLICSUBJECT_DESCRIPTOR)
        field(READTIME_DESCRIPTOR)
        field(SENDER_DESCRIPTOR)
        field(SENTTIME_DESCRIPTOR)
        field(SUBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTARN_DESCRIPTOR.index -> builder.contactArn = deserializeString()
                CONTENT_DESCRIPTOR.index -> builder.content = deserializeString()
                DELIVERYTIME_DESCRIPTOR.index -> builder.deliveryTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                ENGAGEMENTARN_DESCRIPTOR.index -> builder.engagementArn = deserializeString()
                INCIDENTID_DESCRIPTOR.index -> builder.incidentId = deserializeString()
                PAGEARN_DESCRIPTOR.index -> builder.pageArn = deserializeString()
                PUBLICCONTENT_DESCRIPTOR.index -> builder.publicContent = deserializeString()
                PUBLICSUBJECT_DESCRIPTOR.index -> builder.publicSubject = deserializeString()
                READTIME_DESCRIPTOR.index -> builder.readTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                SENDER_DESCRIPTOR.index -> builder.sender = deserializeString()
                SENTTIME_DESCRIPTOR.index -> builder.sentTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                SUBJECT_DESCRIPTOR.index -> builder.subject = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
