// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a shift that belongs to an on-call rotation.
 */
public class RotationShift private constructor(builder: Builder) {
    /**
     * The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation.
     */
    public val contactIds: List<String>? = builder.contactIds
    /**
     * The time a shift rotation ends.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * Additional information about an on-call rotation shift.
     */
    public val shiftDetails: aws.sdk.kotlin.services.ssmcontacts.model.ShiftDetails? = builder.shiftDetails
    /**
     * The time a shift rotation begins.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The type of shift rotation.
     */
    public val type: aws.sdk.kotlin.services.ssmcontacts.model.ShiftType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.RotationShift = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RotationShift(")
        append("contactIds=$contactIds,")
        append("endTime=$endTime,")
        append("shiftDetails=$shiftDetails,")
        append("startTime=$startTime,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactIds?.hashCode() ?: 0
        result = 31 * result + (endTime.hashCode())
        result = 31 * result + (shiftDetails?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RotationShift

        if (contactIds != other.contactIds) return false
        if (endTime != other.endTime) return false
        if (shiftDetails != other.shiftDetails) return false
        if (startTime != other.startTime) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.RotationShift = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Names (ARNs) of the contacts who are part of the shift rotation.
         */
        public var contactIds: List<String>? = null
        /**
         * The time a shift rotation ends.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Additional information about an on-call rotation shift.
         */
        public var shiftDetails: aws.sdk.kotlin.services.ssmcontacts.model.ShiftDetails? = null
        /**
         * The time a shift rotation begins.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of shift rotation.
         */
        public var type: aws.sdk.kotlin.services.ssmcontacts.model.ShiftType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.RotationShift) : this() {
            this.contactIds = x.contactIds
            this.endTime = x.endTime
            this.shiftDetails = x.shiftDetails
            this.startTime = x.startTime
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.RotationShift = RotationShift(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssmcontacts.model.ShiftDetails] inside the given [block]
         */
        public fun shiftDetails(block: aws.sdk.kotlin.services.ssmcontacts.model.ShiftDetails.Builder.() -> kotlin.Unit) {
            this.shiftDetails = aws.sdk.kotlin.services.ssmcontacts.model.ShiftDetails.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
