// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the engagement resolution steps. The resolution starts from the first contact, which can be an escalation plan, then resolves to an on-call rotation, and finally to a personal contact.
 *
 * The `ResolutionContact` structure describes the information for each node or step in that process. It contains information about different contact types, such as the escalation, rotation, and personal contacts.
 */
public class ResolutionContact private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a contact in the engagement resolution process.
     */
    public val contactArn: kotlin.String = requireNotNull(builder.contactArn) { "A non-null value must be provided for contactArn" }
    /**
     * The stage in the escalation plan that resolves to this contact.
     */
    public val stageIndex: kotlin.Int? = builder.stageIndex
    /**
     * The type of contact for a resolution step.
     */
    public val type: aws.sdk.kotlin.services.ssmcontacts.model.ContactType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.ResolutionContact = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResolutionContact(")
        append("contactArn=$contactArn,")
        append("stageIndex=$stageIndex,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactArn.hashCode()
        result = 31 * result + (stageIndex ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResolutionContact

        if (contactArn != other.contactArn) return false
        if (stageIndex != other.stageIndex) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.ResolutionContact = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a contact in the engagement resolution process.
         */
        public var contactArn: kotlin.String? = null
        /**
         * The stage in the escalation plan that resolves to this contact.
         */
        public var stageIndex: kotlin.Int? = null
        /**
         * The type of contact for a resolution step.
         */
        public var type: aws.sdk.kotlin.services.ssmcontacts.model.ContactType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.ResolutionContact) : this() {
            this.contactArn = x.contactArn
            this.stageIndex = x.stageIndex
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.ResolutionContact = ResolutionContact(this)

        internal fun correctErrors(): Builder {
            if (contactArn == null) contactArn = ""
            if (type == null) type = ContactType.SdkUnknown("no value provided")
            return this
        }
    }
}
