// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Incident Manager reaching out to a contact or escalation plan to engage contact during an incident.
 */
public class Engagement private constructor(builder: Builder) {
    /**
     * The ARN of the escalation plan or contact that Incident Manager is engaging.
     */
    public val contactArn: kotlin.String = requireNotNull(builder.contactArn) { "A non-null value must be provided for contactArn" }
    /**
     * The Amazon Resource Name (ARN) of the engagement.
     */
    public val engagementArn: kotlin.String = requireNotNull(builder.engagementArn) { "A non-null value must be provided for engagementArn" }
    /**
     * The ARN of the incident that's engaging the contact.
     */
    public val incidentId: kotlin.String? = builder.incidentId
    /**
     * The user that started the engagement.
     */
    public val sender: kotlin.String = requireNotNull(builder.sender) { "A non-null value must be provided for sender" }
    /**
     * The time that the engagement began.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The time that the engagement ended.
     */
    public val stopTime: aws.smithy.kotlin.runtime.time.Instant? = builder.stopTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.Engagement = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Engagement(")
        append("contactArn=$contactArn,")
        append("engagementArn=$engagementArn,")
        append("incidentId=$incidentId,")
        append("sender=$sender,")
        append("startTime=$startTime,")
        append("stopTime=$stopTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactArn.hashCode()
        result = 31 * result + (engagementArn.hashCode())
        result = 31 * result + (incidentId?.hashCode() ?: 0)
        result = 31 * result + (sender.hashCode())
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (stopTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Engagement

        if (contactArn != other.contactArn) return false
        if (engagementArn != other.engagementArn) return false
        if (incidentId != other.incidentId) return false
        if (sender != other.sender) return false
        if (startTime != other.startTime) return false
        if (stopTime != other.stopTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.Engagement = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the escalation plan or contact that Incident Manager is engaging.
         */
        public var contactArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the engagement.
         */
        public var engagementArn: kotlin.String? = null
        /**
         * The ARN of the incident that's engaging the contact.
         */
        public var incidentId: kotlin.String? = null
        /**
         * The user that started the engagement.
         */
        public var sender: kotlin.String? = null
        /**
         * The time that the engagement began.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time that the engagement ended.
         */
        public var stopTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.Engagement) : this() {
            this.contactArn = x.contactArn
            this.engagementArn = x.engagementArn
            this.incidentId = x.incidentId
            this.sender = x.sender
            this.startTime = x.startTime
            this.stopTime = x.stopTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.Engagement = Engagement(this)

        internal fun correctErrors(): Builder {
            if (contactArn == null) contactArn = ""
            if (engagementArn == null) engagementArn = ""
            if (sender == null) sender = ""
            return this
        }
    }
}
