// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateRotationRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
     *
     * The order that you list the contacts in is their shift order in the rotation schedule. To change the order of the contact's shifts, use the UpdateRotation operation.
     */
    public val contactIds: List<String>? = builder.contactIds
    /**
     * A token that ensures that the operation is called only once with the specified details.
     */
    public val idempotencyToken: kotlin.String? = builder.idempotencyToken
    /**
     * The name of the rotation.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Information about the rule that specifies when a shift's team members rotate.
     */
    public val recurrence: aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings? = builder.recurrence
    /**
     * The date and time that the rotation goes into effect.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For more information, see [Tagging Incident Manager resources](https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html) in the *Incident Manager User Guide*.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the [Time Zone Database](https://www.iana.org/time-zones) on the IANA website.
     *
     * Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time (PST) and Pacific Daylight Time (PDT), are not supported.
     */
    public val timeZoneId: kotlin.String? = builder.timeZoneId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.CreateRotationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRotationRequest(")
        append("contactIds=$contactIds,")
        append("idempotencyToken=$idempotencyToken,")
        append("name=$name,")
        append("recurrence=$recurrence,")
        append("startTime=$startTime,")
        append("tags=$tags,")
        append("timeZoneId=$timeZoneId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactIds?.hashCode() ?: 0
        result = 31 * result + (idempotencyToken?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recurrence?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (timeZoneId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRotationRequest

        if (contactIds != other.contactIds) return false
        if (idempotencyToken != other.idempotencyToken) return false
        if (name != other.name) return false
        if (recurrence != other.recurrence) return false
        if (startTime != other.startTime) return false
        if (tags != other.tags) return false
        if (timeZoneId != other.timeZoneId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.CreateRotationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Names (ARNs) of the contacts to add to the rotation.
         *
         * The order that you list the contacts in is their shift order in the rotation schedule. To change the order of the contact's shifts, use the UpdateRotation operation.
         */
        public var contactIds: List<String>? = null
        /**
         * A token that ensures that the operation is called only once with the specified details.
         */
        public var idempotencyToken: kotlin.String? = null
        /**
         * The name of the rotation.
         */
        public var name: kotlin.String? = null
        /**
         * Information about the rule that specifies when a shift's team members rotate.
         */
        public var recurrence: aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings? = null
        /**
         * The date and time that the rotation goes into effect.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Optional metadata to assign to the rotation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For more information, see [Tagging Incident Manager resources](https://docs.aws.amazon.com/incident-manager/latest/userguide/tagging.html) in the *Incident Manager User Guide*.
         */
        public var tags: List<Tag>? = null
        /**
         * The time zone to base the rotation’s activity on in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the [Time Zone Database](https://www.iana.org/time-zones) on the IANA website.
         *
         * Designators for time zones that don’t support Daylight Savings Time rules, such as Pacific Standard Time (PST) and Pacific Daylight Time (PDT), are not supported.
         */
        public var timeZoneId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.CreateRotationRequest) : this() {
            this.contactIds = x.contactIds
            this.idempotencyToken = x.idempotencyToken
            this.name = x.name
            this.recurrence = x.recurrence
            this.startTime = x.startTime
            this.tags = x.tags
            this.timeZoneId = x.timeZoneId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.CreateRotationRequest = CreateRotationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings] inside the given [block]
         */
        public fun recurrence(block: aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings.Builder.() -> kotlin.Unit) {
            this.recurrence = aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
