// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Records events during an engagement.
 */
public class Receipt private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
     */
    public val contactChannelArn: kotlin.String? = builder.contactChannelArn
    /**
     * Information provided during the page acknowledgement.
     */
    public val receiptInfo: kotlin.String? = builder.receiptInfo
    /**
     * The time receipt was `SENT`, `DELIVERED`, or `READ`.
     */
    public val receiptTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.receiptTime) { "A non-null value must be provided for receiptTime" }
    /**
     * The type follows the engagement cycle, `SENT`, `DELIVERED`, and `READ`.
     */
    public val receiptType: aws.sdk.kotlin.services.ssmcontacts.model.ReceiptType = requireNotNull(builder.receiptType) { "A non-null value must be provided for receiptType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.Receipt = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Receipt(")
        append("contactChannelArn=$contactChannelArn,")
        append("receiptInfo=$receiptInfo,")
        append("receiptTime=$receiptTime,")
        append("receiptType=$receiptType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactChannelArn?.hashCode() ?: 0
        result = 31 * result + (receiptInfo?.hashCode() ?: 0)
        result = 31 * result + (receiptTime.hashCode())
        result = 31 * result + (receiptType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Receipt

        if (contactChannelArn != other.contactChannelArn) return false
        if (receiptInfo != other.receiptInfo) return false
        if (receiptTime != other.receiptTime) return false
        if (receiptType != other.receiptType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.Receipt = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the contact channel Incident Manager engaged.
         */
        public var contactChannelArn: kotlin.String? = null
        /**
         * Information provided during the page acknowledgement.
         */
        public var receiptInfo: kotlin.String? = null
        /**
         * The time receipt was `SENT`, `DELIVERED`, or `READ`.
         */
        public var receiptTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type follows the engagement cycle, `SENT`, `DELIVERED`, and `READ`.
         */
        public var receiptType: aws.sdk.kotlin.services.ssmcontacts.model.ReceiptType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.Receipt) : this() {
            this.contactChannelArn = x.contactChannelArn
            this.receiptInfo = x.receiptInfo
            this.receiptTime = x.receiptTime
            this.receiptType = x.receiptType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.Receipt = Receipt(this)

        internal fun correctErrors(): Builder {
            if (receiptTime == null) receiptTime = Instant.fromEpochSeconds(0)
            if (receiptType == null) receiptType = ReceiptType.SdkUnknown("no value provided")
            return this
        }
    }
}
