// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.serde

import aws.sdk.kotlin.services.ssmcontacts.model.DescribeEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.SsmContactsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeEngagementOperationDeserializer: HttpDeserialize<DescribeEngagementResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeEngagementResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeEngagementError(context, call)
        }
        val builder = DescribeEngagementResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEngagementOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeEngagementError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmContactsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "DataEncryptionException" -> DataEncryptionExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> SsmContactsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEngagementOperationBody(builder: DescribeEngagementResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactArn"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Content"))
    val ENGAGEMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EngagementArn"))
    val INCIDENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IncidentId"))
    val PUBLICCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PublicContent"))
    val PUBLICSUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PublicSubject"))
    val SENDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Sender"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STOPTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StopTime"))
    val SUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Subject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTARN_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(ENGAGEMENTARN_DESCRIPTOR)
        field(INCIDENTID_DESCRIPTOR)
        field(PUBLICCONTENT_DESCRIPTOR)
        field(PUBLICSUBJECT_DESCRIPTOR)
        field(SENDER_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STOPTIME_DESCRIPTOR)
        field(SUBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTARN_DESCRIPTOR.index -> builder.contactArn = deserializeString()
                CONTENT_DESCRIPTOR.index -> builder.content = deserializeString()
                ENGAGEMENTARN_DESCRIPTOR.index -> builder.engagementArn = deserializeString()
                INCIDENTID_DESCRIPTOR.index -> builder.incidentId = deserializeString()
                PUBLICCONTENT_DESCRIPTOR.index -> builder.publicContent = deserializeString()
                PUBLICSUBJECT_DESCRIPTOR.index -> builder.publicSubject = deserializeString()
                SENDER_DESCRIPTOR.index -> builder.sender = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                STOPTIME_DESCRIPTOR.index -> builder.stopTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SUBJECT_DESCRIPTOR.index -> builder.subject = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
