// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an override specified for an on-call rotation.
 */
public class RotationOverride private constructor(builder: Builder) {
    /**
     * The time a rotation override was created.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The time a rotation override ends.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.endTime) { "A non-null value must be provided for endTime" }
    /**
     * The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
     */
    public val newContactIds: List<String> = requireNotNull(builder.newContactIds) { "A non-null value must be provided for newContactIds" }
    /**
     * The Amazon Resource Name (ARN) of the override to an on-call rotation.
     */
    public val rotationOverrideId: kotlin.String = requireNotNull(builder.rotationOverrideId) { "A non-null value must be provided for rotationOverrideId" }
    /**
     * The time a rotation override begins.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.RotationOverride = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RotationOverride(")
        append("createTime=$createTime,")
        append("endTime=$endTime,")
        append("newContactIds=$newContactIds,")
        append("rotationOverrideId=$rotationOverrideId,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createTime.hashCode()
        result = 31 * result + (endTime.hashCode())
        result = 31 * result + (newContactIds.hashCode())
        result = 31 * result + (rotationOverrideId.hashCode())
        result = 31 * result + (startTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RotationOverride

        if (createTime != other.createTime) return false
        if (endTime != other.endTime) return false
        if (newContactIds != other.newContactIds) return false
        if (rotationOverrideId != other.rotationOverrideId) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.RotationOverride = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The time a rotation override was created.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time a rotation override ends.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Names (ARNs) of the contacts assigned to the override of the on-call rotation.
         */
        public var newContactIds: List<String>? = null
        /**
         * The Amazon Resource Name (ARN) of the override to an on-call rotation.
         */
        public var rotationOverrideId: kotlin.String? = null
        /**
         * The time a rotation override begins.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.RotationOverride) : this() {
            this.createTime = x.createTime
            this.endTime = x.endTime
            this.newContactIds = x.newContactIds
            this.rotationOverrideId = x.rotationOverrideId
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.RotationOverride = RotationOverride(this)

        internal fun correctErrors(): Builder {
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            if (newContactIds == null) newContactIds = emptyList()
            if (rotationOverrideId == null) rotationOverrideId = ""
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
