// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribePageResponse private constructor(builder: Builder) {
    /**
     * The ARN of the contact that was engaged.
     */
    public val contactArn: kotlin.String = requireNotNull(builder.contactArn) { "A non-null value must be provided for contactArn" }
    /**
     * The secure content of the message that was sent to the contact. Use this field for engagements to `VOICE` and `EMAIL`.
     */
    public val content: kotlin.String = requireNotNull(builder.content) { "A non-null value must be provided for content" }
    /**
     * The time that the contact channel received the engagement.
     */
    public val deliveryTime: aws.smithy.kotlin.runtime.time.Instant? = builder.deliveryTime
    /**
     * The ARN of the engagement that engaged the contact channel.
     */
    public val engagementArn: kotlin.String = requireNotNull(builder.engagementArn) { "A non-null value must be provided for engagementArn" }
    /**
     * The ARN of the incident that engaged the contact channel.
     */
    public val incidentId: kotlin.String? = builder.incidentId
    /**
     * The Amazon Resource Name (ARN) of the engagement to a contact channel.
     */
    public val pageArn: kotlin.String = requireNotNull(builder.pageArn) { "A non-null value must be provided for pageArn" }
    /**
     * The insecure content of the message that was sent to the contact. Use this field for engagements to `SMS`.
     */
    public val publicContent: kotlin.String? = builder.publicContent
    /**
     * The insecure subject of the message that was sent to the contact. Use this field for engagements to `SMS`.
     */
    public val publicSubject: kotlin.String? = builder.publicSubject
    /**
     * The time that the contact channel acknowledged the engagement.
     */
    public val readTime: aws.smithy.kotlin.runtime.time.Instant? = builder.readTime
    /**
     * The user that started the engagement.
     */
    public val sender: kotlin.String = requireNotNull(builder.sender) { "A non-null value must be provided for sender" }
    /**
     * The time the engagement was sent to the contact channel.
     */
    public val sentTime: aws.smithy.kotlin.runtime.time.Instant? = builder.sentTime
    /**
     * The secure subject of the message that was sent to the contact. Use this field for engagements to `VOICE` and `EMAIL`.
     */
    public val subject: kotlin.String = requireNotNull(builder.subject) { "A non-null value must be provided for subject" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.DescribePageResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribePageResponse(")
        append("contactArn=$contactArn,")
        append("content=$content,")
        append("deliveryTime=$deliveryTime,")
        append("engagementArn=$engagementArn,")
        append("incidentId=$incidentId,")
        append("pageArn=$pageArn,")
        append("publicContent=$publicContent,")
        append("publicSubject=$publicSubject,")
        append("readTime=$readTime,")
        append("sender=$sender,")
        append("sentTime=$sentTime,")
        append("subject=$subject")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactArn.hashCode()
        result = 31 * result + (content.hashCode())
        result = 31 * result + (deliveryTime?.hashCode() ?: 0)
        result = 31 * result + (engagementArn.hashCode())
        result = 31 * result + (incidentId?.hashCode() ?: 0)
        result = 31 * result + (pageArn.hashCode())
        result = 31 * result + (publicContent?.hashCode() ?: 0)
        result = 31 * result + (publicSubject?.hashCode() ?: 0)
        result = 31 * result + (readTime?.hashCode() ?: 0)
        result = 31 * result + (sender.hashCode())
        result = 31 * result + (sentTime?.hashCode() ?: 0)
        result = 31 * result + (subject.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribePageResponse

        if (contactArn != other.contactArn) return false
        if (content != other.content) return false
        if (deliveryTime != other.deliveryTime) return false
        if (engagementArn != other.engagementArn) return false
        if (incidentId != other.incidentId) return false
        if (pageArn != other.pageArn) return false
        if (publicContent != other.publicContent) return false
        if (publicSubject != other.publicSubject) return false
        if (readTime != other.readTime) return false
        if (sender != other.sender) return false
        if (sentTime != other.sentTime) return false
        if (subject != other.subject) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.DescribePageResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ARN of the contact that was engaged.
         */
        public var contactArn: kotlin.String? = null
        /**
         * The secure content of the message that was sent to the contact. Use this field for engagements to `VOICE` and `EMAIL`.
         */
        public var content: kotlin.String? = null
        /**
         * The time that the contact channel received the engagement.
         */
        public var deliveryTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ARN of the engagement that engaged the contact channel.
         */
        public var engagementArn: kotlin.String? = null
        /**
         * The ARN of the incident that engaged the contact channel.
         */
        public var incidentId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the engagement to a contact channel.
         */
        public var pageArn: kotlin.String? = null
        /**
         * The insecure content of the message that was sent to the contact. Use this field for engagements to `SMS`.
         */
        public var publicContent: kotlin.String? = null
        /**
         * The insecure subject of the message that was sent to the contact. Use this field for engagements to `SMS`.
         */
        public var publicSubject: kotlin.String? = null
        /**
         * The time that the contact channel acknowledged the engagement.
         */
        public var readTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The user that started the engagement.
         */
        public var sender: kotlin.String? = null
        /**
         * The time the engagement was sent to the contact channel.
         */
        public var sentTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The secure subject of the message that was sent to the contact. Use this field for engagements to `VOICE` and `EMAIL`.
         */
        public var subject: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.DescribePageResponse) : this() {
            this.contactArn = x.contactArn
            this.content = x.content
            this.deliveryTime = x.deliveryTime
            this.engagementArn = x.engagementArn
            this.incidentId = x.incidentId
            this.pageArn = x.pageArn
            this.publicContent = x.publicContent
            this.publicSubject = x.publicSubject
            this.readTime = x.readTime
            this.sender = x.sender
            this.sentTime = x.sentTime
            this.subject = x.subject
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.DescribePageResponse = DescribePageResponse(this)

        internal fun correctErrors(): Builder {
            if (contactArn == null) contactArn = ""
            if (content == null) content = ""
            if (engagementArn == null) engagementArn = ""
            if (pageArn == null) pageArn = ""
            if (sender == null) sender = ""
            if (subject == null) subject = ""
            return this
        }
    }
}
