// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.transform

import aws.sdk.kotlin.services.ssmcontacts.model.GetRotationOverrideResponse
import aws.sdk.kotlin.services.ssmcontacts.model.SsmContactsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetRotationOverrideOperationDeserializer: HttpDeserialize<GetRotationOverrideResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRotationOverrideResponse {
        if (!response.status.isSuccess()) {
            throwGetRotationOverrideError(context, response)
        }
        val builder = GetRotationOverrideResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRotationOverrideOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRotationOverrideError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmContactsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmContactsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRotationOverrideOperationBody(builder: GetRotationOverrideResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreateTime"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val NEWCONTACTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("NewContactIds"))
    val ROTATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RotationArn"))
    val ROTATIONOVERRIDEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RotationOverrideId"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATETIME_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(NEWCONTACTIDS_DESCRIPTOR)
        field(ROTATIONARN_DESCRIPTOR)
        field(ROTATIONOVERRIDEID_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATETIME_DESCRIPTOR.index -> builder.createTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NEWCONTACTIDS_DESCRIPTOR.index -> builder.newContactIds =
                    deserializer.deserializeList(NEWCONTACTIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ROTATIONARN_DESCRIPTOR.index -> builder.rotationArn = deserializeString()
                ROTATIONOVERRIDEID_DESCRIPTOR.index -> builder.rotationOverrideId = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
