// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.transform

import aws.sdk.kotlin.services.ssmcontacts.model.GetRotationResponse
import aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings
import aws.sdk.kotlin.services.ssmcontacts.model.SsmContactsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetRotationOperationDeserializer: HttpDeserialize<GetRotationResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRotationResponse {
        if (!response.status.isSuccess()) {
            throwGetRotationError(context, response)
        }
        val builder = GetRotationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRotationOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetRotationError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmContactsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmContactsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRotationOperationBody(builder: GetRotationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ContactIds"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val RECURRENCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Recurrence"))
    val ROTATIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RotationArn"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val TIMEZONEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TimeZoneId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTIDS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RECURRENCE_DESCRIPTOR)
        field(ROTATIONARN_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(TIMEZONEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTIDS_DESCRIPTOR.index -> builder.contactIds =
                    deserializer.deserializeList(CONTACTIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                RECURRENCE_DESCRIPTOR.index -> builder.recurrence = deserializeRecurrenceSettingsDocument(deserializer)
                ROTATIONARN_DESCRIPTOR.index -> builder.rotationArn = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                TIMEZONEID_DESCRIPTOR.index -> builder.timeZoneId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
