// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.transform

import aws.sdk.kotlin.services.ssmcontacts.model.ContactType
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.Plan
import aws.sdk.kotlin.services.ssmcontacts.model.SsmContactsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetContactOperationDeserializer: HttpDeserialize<GetContactResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetContactResponse {
        if (!response.status.isSuccess()) {
            throwGetContactError(context, response)
        }
        val builder = GetContactResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetContactOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetContactError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmContactsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DataEncryptionException" -> DataEncryptionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmContactsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetContactOperationBody(builder: GetContactResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALIAS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Alias"))
    val CONTACTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactArn"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DisplayName"))
    val PLAN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Plan"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALIAS_DESCRIPTOR)
        field(CONTACTARN_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(PLAN_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALIAS_DESCRIPTOR.index -> builder.alias = deserializeString()
                CONTACTARN_DESCRIPTOR.index -> builder.contactArn = deserializeString()
                DISPLAYNAME_DESCRIPTOR.index -> builder.displayName = deserializeString()
                PLAN_DESCRIPTOR.index -> builder.plan = deserializePlanDocument(deserializer)
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { ContactType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
