// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.transform

import aws.sdk.kotlin.services.ssmcontacts.model.ActivationStatus
import aws.sdk.kotlin.services.ssmcontacts.model.ChannelType
import aws.sdk.kotlin.services.ssmcontacts.model.ContactChannelAddress
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.SsmContactsException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetContactChannelOperationDeserializer: HttpDeserialize<GetContactChannelResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetContactChannelResponse {
        if (!response.status.isSuccess()) {
            throwGetContactChannelError(context, response)
        }
        val builder = GetContactChannelResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetContactChannelOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetContactChannelError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmContactsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DataEncryptionException" -> DataEncryptionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmContactsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetContactChannelOperationBody(builder: GetContactChannelResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACTIVATIONSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ActivationStatus"))
    val CONTACTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactArn"))
    val CONTACTCHANNELARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactChannelArn"))
    val DELIVERYADDRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DeliveryAddress"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACTIVATIONSTATUS_DESCRIPTOR)
        field(CONTACTARN_DESCRIPTOR)
        field(CONTACTCHANNELARN_DESCRIPTOR)
        field(DELIVERYADDRESS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACTIVATIONSTATUS_DESCRIPTOR.index -> builder.activationStatus = deserializeString().let { ActivationStatus.fromValue(it) }
                CONTACTARN_DESCRIPTOR.index -> builder.contactArn = deserializeString()
                CONTACTCHANNELARN_DESCRIPTOR.index -> builder.contactChannelArn = deserializeString()
                DELIVERYADDRESS_DESCRIPTOR.index -> builder.deliveryAddress = deserializeContactChannelAddressDocument(deserializer)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { ChannelType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
