// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.model

import aws.smithy.kotlin.runtime.time.Instant

public class UpdateRotationRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation.
     *
     * The order in which you list the contacts is their shift order in the rotation schedule.
     */
    public val contactIds: List<String>? = builder.contactIds
    /**
     * Information about how long the updated rotation lasts before restarting at the beginning of the shift order.
     */
    public val recurrence: aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings? = builder.recurrence
    /**
     * The Amazon Resource Name (ARN) of the rotation to update.
     */
    public val rotationId: kotlin.String? = builder.rotationId
    /**
     * The date and time the rotation goes into effect.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The time zone to base the updated rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the [Time Zone Database](https://www.iana.org/time-zones) on the IANA website.
     *
     * Designators for time zones that don’t support Daylight Savings Time Rules, such as Pacific Standard Time (PST) and Pacific Daylight Time (PDT), aren't supported.
     */
    public val timeZoneId: kotlin.String? = builder.timeZoneId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssmcontacts.model.UpdateRotationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateRotationRequest(")
        append("contactIds=$contactIds,")
        append("recurrence=$recurrence,")
        append("rotationId=$rotationId,")
        append("startTime=$startTime,")
        append("timeZoneId=$timeZoneId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = contactIds?.hashCode() ?: 0
        result = 31 * result + (recurrence?.hashCode() ?: 0)
        result = 31 * result + (rotationId?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (timeZoneId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateRotationRequest

        if (contactIds != other.contactIds) return false
        if (recurrence != other.recurrence) return false
        if (rotationId != other.rotationId) return false
        if (startTime != other.startTime) return false
        if (timeZoneId != other.timeZoneId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssmcontacts.model.UpdateRotationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Names (ARNs) of the contacts to include in the updated rotation.
         *
         * The order in which you list the contacts is their shift order in the rotation schedule.
         */
        public var contactIds: List<String>? = null
        /**
         * Information about how long the updated rotation lasts before restarting at the beginning of the shift order.
         */
        public var recurrence: aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings? = null
        /**
         * The Amazon Resource Name (ARN) of the rotation to update.
         */
        public var rotationId: kotlin.String? = null
        /**
         * The date and time the rotation goes into effect.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time zone to base the updated rotation’s activity on, in Internet Assigned Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see the [Time Zone Database](https://www.iana.org/time-zones) on the IANA website.
         *
         * Designators for time zones that don’t support Daylight Savings Time Rules, such as Pacific Standard Time (PST) and Pacific Daylight Time (PDT), aren't supported.
         */
        public var timeZoneId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssmcontacts.model.UpdateRotationRequest) : this() {
            this.contactIds = x.contactIds
            this.recurrence = x.recurrence
            this.rotationId = x.rotationId
            this.startTime = x.startTime
            this.timeZoneId = x.timeZoneId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssmcontacts.model.UpdateRotationRequest = UpdateRotationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings] inside the given [block]
         */
        public fun recurrence(block: aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings.Builder.() -> kotlin.Unit) {
            this.recurrence = aws.sdk.kotlin.services.ssmcontacts.model.RecurrenceSettings.invoke(block)
        }
    }
}
