// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.ssmcontacts.model.DescribePageResponse
import aws.sdk.kotlin.services.ssmcontacts.model.SsmContactsException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribePageOperationDeserializer: HttpDeserialize<DescribePageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribePageResponse {
        if (!response.status.isSuccess()) {
            throwDescribePageError(context, response)
        }
        val builder = DescribePageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribePageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribePageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw SsmContactsException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "DataEncryptionException" -> DataEncryptionExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> SsmContactsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribePageOperationBody(builder: DescribePageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONTACTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ContactArn"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Content"))
    val DELIVERYTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DeliveryTime"))
    val ENGAGEMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EngagementArn"))
    val INCIDENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IncidentId"))
    val PAGEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PageArn"))
    val PUBLICCONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PublicContent"))
    val PUBLICSUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PublicSubject"))
    val READTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ReadTime"))
    val SENDER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Sender"))
    val SENTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("SentTime"))
    val SUBJECT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Subject"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONTACTARN_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(DELIVERYTIME_DESCRIPTOR)
        field(ENGAGEMENTARN_DESCRIPTOR)
        field(INCIDENTID_DESCRIPTOR)
        field(PAGEARN_DESCRIPTOR)
        field(PUBLICCONTENT_DESCRIPTOR)
        field(PUBLICSUBJECT_DESCRIPTOR)
        field(READTIME_DESCRIPTOR)
        field(SENDER_DESCRIPTOR)
        field(SENTTIME_DESCRIPTOR)
        field(SUBJECT_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONTACTARN_DESCRIPTOR.index -> builder.contactArn = deserializeString()
                CONTENT_DESCRIPTOR.index -> builder.content = deserializeString()
                DELIVERYTIME_DESCRIPTOR.index -> builder.deliveryTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENGAGEMENTARN_DESCRIPTOR.index -> builder.engagementArn = deserializeString()
                INCIDENTID_DESCRIPTOR.index -> builder.incidentId = deserializeString()
                PAGEARN_DESCRIPTOR.index -> builder.pageArn = deserializeString()
                PUBLICCONTENT_DESCRIPTOR.index -> builder.publicContent = deserializeString()
                PUBLICSUBJECT_DESCRIPTOR.index -> builder.publicSubject = deserializeString()
                READTIME_DESCRIPTOR.index -> builder.readTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SENDER_DESCRIPTOR.index -> builder.sender = deserializeString()
                SENTTIME_DESCRIPTOR.index -> builder.sentTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SUBJECT_DESCRIPTOR.index -> builder.subject = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
