// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.ssmcontacts.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.ssmcontacts.endpoints.EndpointProvider
import aws.sdk.kotlin.services.ssmcontacts.model.*
import aws.sdk.kotlin.services.ssmcontacts.model.AcceptPageRequest
import aws.sdk.kotlin.services.ssmcontacts.model.AcceptPageResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ActivateContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ActivateContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.CreateContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.CreateContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.CreateContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.CreateContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DeactivateContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DeactivateContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DeleteContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DescribeEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DescribeEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.DescribePageRequest
import aws.sdk.kotlin.services.ssmcontacts.model.DescribePageResponse
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactPolicyRequest
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactPolicyResponse
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.GetContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactChannelsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactChannelsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListEngagementsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListEngagementsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPageReceiptsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPageReceiptsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.ssmcontacts.model.PutContactPolicyRequest
import aws.sdk.kotlin.services.ssmcontacts.model.PutContactPolicyResponse
import aws.sdk.kotlin.services.ssmcontacts.model.SendActivationCodeRequest
import aws.sdk.kotlin.services.ssmcontacts.model.SendActivationCodeResponse
import aws.sdk.kotlin.services.ssmcontacts.model.StartEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.StartEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.StopEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.StopEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.TagResourceRequest
import aws.sdk.kotlin.services.ssmcontacts.model.TagResourceResponse
import aws.sdk.kotlin.services.ssmcontacts.model.UntagResourceRequest
import aws.sdk.kotlin.services.ssmcontacts.model.UntagResourceResponse
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateContactChannelRequest
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateContactChannelResponse
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.UpdateContactResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * Systems Manager Incident Manager is an incident management console designed to help users mitigate and recover from incidents affecting their Amazon Web Services-hosted applications. An incident is any unplanned interruption or reduction in quality of services.
 *
 * Incident Manager increases incident resolution by notifying responders of impact, highlighting relevant troubleshooting data, and providing collaboration tools to get services back up and running. To achieve the primary goal of reducing the time-to-resolution of critical incidents, Incident Manager automates response plans and enables responder team escalation.
 */
public interface SsmContactsClient : SdkClient {

    override val serviceName: String
        get() = "SSM Contacts"
    /**
     * SsmContactsClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): SsmContactsClient {
            val config = Config.Builder().apply(block).build()
            return DefaultSsmContactsClient(config)
        }

        public operator fun invoke(config: Config): SsmContactsClient = DefaultSsmContactsClient(config)

        /**
         * Construct a [SsmContactsClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): SsmContactsClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultSsmContactsClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "SSM Contacts")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Used to acknowledge an engagement to a contact channel during an incident.
     */
    public suspend fun acceptPage(input: AcceptPageRequest): AcceptPageResponse

    /**
     * Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been activated.
     */
    public suspend fun activateContactChannel(input: ActivateContactChannelRequest): ActivateContactChannelResponse

    /**
     * Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident.
     */
    public suspend fun createContact(input: CreateContactRequest): CreateContactResponse

    /**
     * A contact channel is the method that Incident Manager uses to engage your contact.
     */
    public suspend fun createContactChannel(input: CreateContactChannelRequest): CreateContactChannelResponse

    /**
     * To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.
     */
    public suspend fun deactivateContactChannel(input: DeactivateContactChannelRequest): DeactivateContactChannelResponse

    /**
     * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all escalation plans and related response plans. Deleting an escalation plan removes it from all related response plans. You will have to recreate the contact and its contact channels before you can use it again.
     */
    public suspend fun deleteContact(input: DeleteContactRequest): DeleteContactResponse

    /**
     * To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a contact, you won't be able to engage that contact during an incident.
     */
    public suspend fun deleteContactChannel(input: DeleteContactChannelRequest): DeleteContactChannelResponse

    /**
     * Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to describe the engagement that occurred during an incident.
     */
    public suspend fun describeEngagement(input: DescribeEngagementRequest): DescribeEngagementResponse

    /**
     * Lists details of the engagement to a contact channel.
     */
    public suspend fun describePage(input: DescribePageRequest): DescribePageResponse

    /**
     * Retrieves information about the specified contact or escalation plan.
     */
    public suspend fun getContact(input: GetContactRequest): GetContactResponse

    /**
     * List details about a specific contact channel.
     */
    public suspend fun getContactChannel(input: GetContactChannelRequest): GetContactChannelResponse

    /**
     * Retrieves the resource policies attached to the specified contact or escalation plan.
     */
    public suspend fun getContactPolicy(input: GetContactPolicyRequest): GetContactPolicyResponse

    /**
     * Lists all contact channels for the specified contact.
     */
    public suspend fun listContactChannels(input: ListContactChannelsRequest): ListContactChannelsResponse

    /**
     * Lists all contacts and escalation plans in Incident Manager.
     */
    public suspend fun listContacts(input: ListContactsRequest = ListContactsRequest {}): ListContactsResponse

    /**
     * Lists all engagements that have happened in an incident.
     */
    public suspend fun listEngagements(input: ListEngagementsRequest = ListEngagementsRequest {}): ListEngagementsResponse

    /**
     * Lists all of the engagements to contact channels that have been acknowledged.
     */
    public suspend fun listPageReceipts(input: ListPageReceiptsRequest): ListPageReceiptsResponse

    /**
     * Lists the engagements to a contact's contact channels.
     */
    public suspend fun listPagesByContact(input: ListPagesByContactRequest): ListPagesByContactResponse

    /**
     * Lists the engagements to contact channels that occurred by engaging a contact.
     */
    public suspend fun listPagesByEngagement(input: ListPagesByEngagementRequest): ListPagesByEngagementResponse

    /**
     * Lists the tags of an escalation plan or contact.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Adds a resource policy to the specified contact or escalation plan. The resource policy is used to share the contact or escalation plan using Resource Access Manager (RAM). For more information about cross-account sharing, see [Setting up cross-account functionality](https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html).
     */
    public suspend fun putContactPolicy(input: PutContactPolicyRequest): PutContactPolicyResponse

    /**
     * Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in the console or with the `ActivateChannel` operation. Incident Manager can't engage a contact channel until it has been activated.
     */
    public suspend fun sendActivationCode(input: SendActivationCodeRequest): SendActivationCodeResponse

    /**
     * Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.
     */
    public suspend fun startEngagement(input: StartEngagementRequest): StartEngagementResponse

    /**
     * Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further contacts aren't engaged.
     */
    public suspend fun stopEngagement(input: StopEngagementRequest): StopEngagementResponse

    /**
     * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your replication set.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes tags from the specified resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the contact or escalation plan specified.
     */
    public suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse

    /**
     * Updates a contact's contact channel.
     */
    public suspend fun updateContactChannel(input: UpdateContactChannelRequest): UpdateContactChannelResponse
}

/**
 * Used to acknowledge an engagement to a contact channel during an incident.
 */
public suspend inline fun SsmContactsClient.acceptPage(crossinline block: AcceptPageRequest.Builder.() -> Unit): AcceptPageResponse = acceptPage(AcceptPageRequest.Builder().apply(block).build())

/**
 * Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been activated.
 */
public suspend inline fun SsmContactsClient.activateContactChannel(crossinline block: ActivateContactChannelRequest.Builder.() -> Unit): ActivateContactChannelResponse = activateContactChannel(ActivateContactChannelRequest.Builder().apply(block).build())

/**
 * Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident.
 */
public suspend inline fun SsmContactsClient.createContact(crossinline block: CreateContactRequest.Builder.() -> Unit): CreateContactResponse = createContact(CreateContactRequest.Builder().apply(block).build())

/**
 * A contact channel is the method that Incident Manager uses to engage your contact.
 */
public suspend inline fun SsmContactsClient.createContactChannel(crossinline block: CreateContactChannelRequest.Builder.() -> Unit): CreateContactChannelResponse = createContactChannel(CreateContactChannelRequest.Builder().apply(block).build())

/**
 * To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.
 */
public suspend inline fun SsmContactsClient.deactivateContactChannel(crossinline block: DeactivateContactChannelRequest.Builder.() -> Unit): DeactivateContactChannelResponse = deactivateContactChannel(DeactivateContactChannelRequest.Builder().apply(block).build())

/**
 * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all escalation plans and related response plans. Deleting an escalation plan removes it from all related response plans. You will have to recreate the contact and its contact channels before you can use it again.
 */
public suspend inline fun SsmContactsClient.deleteContact(crossinline block: DeleteContactRequest.Builder.() -> Unit): DeleteContactResponse = deleteContact(DeleteContactRequest.Builder().apply(block).build())

/**
 * To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a contact, you won't be able to engage that contact during an incident.
 */
public suspend inline fun SsmContactsClient.deleteContactChannel(crossinline block: DeleteContactChannelRequest.Builder.() -> Unit): DeleteContactChannelResponse = deleteContactChannel(DeleteContactChannelRequest.Builder().apply(block).build())

/**
 * Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to describe the engagement that occurred during an incident.
 */
public suspend inline fun SsmContactsClient.describeEngagement(crossinline block: DescribeEngagementRequest.Builder.() -> Unit): DescribeEngagementResponse = describeEngagement(DescribeEngagementRequest.Builder().apply(block).build())

/**
 * Lists details of the engagement to a contact channel.
 */
public suspend inline fun SsmContactsClient.describePage(crossinline block: DescribePageRequest.Builder.() -> Unit): DescribePageResponse = describePage(DescribePageRequest.Builder().apply(block).build())

/**
 * Retrieves information about the specified contact or escalation plan.
 */
public suspend inline fun SsmContactsClient.getContact(crossinline block: GetContactRequest.Builder.() -> Unit): GetContactResponse = getContact(GetContactRequest.Builder().apply(block).build())

/**
 * List details about a specific contact channel.
 */
public suspend inline fun SsmContactsClient.getContactChannel(crossinline block: GetContactChannelRequest.Builder.() -> Unit): GetContactChannelResponse = getContactChannel(GetContactChannelRequest.Builder().apply(block).build())

/**
 * Retrieves the resource policies attached to the specified contact or escalation plan.
 */
public suspend inline fun SsmContactsClient.getContactPolicy(crossinline block: GetContactPolicyRequest.Builder.() -> Unit): GetContactPolicyResponse = getContactPolicy(GetContactPolicyRequest.Builder().apply(block).build())

/**
 * Lists all contact channels for the specified contact.
 */
public suspend inline fun SsmContactsClient.listContactChannels(crossinline block: ListContactChannelsRequest.Builder.() -> Unit): ListContactChannelsResponse = listContactChannels(ListContactChannelsRequest.Builder().apply(block).build())

/**
 * Lists all contacts and escalation plans in Incident Manager.
 */
public suspend inline fun SsmContactsClient.listContacts(crossinline block: ListContactsRequest.Builder.() -> Unit): ListContactsResponse = listContacts(ListContactsRequest.Builder().apply(block).build())

/**
 * Lists all engagements that have happened in an incident.
 */
public suspend inline fun SsmContactsClient.listEngagements(crossinline block: ListEngagementsRequest.Builder.() -> Unit): ListEngagementsResponse = listEngagements(ListEngagementsRequest.Builder().apply(block).build())

/**
 * Lists all of the engagements to contact channels that have been acknowledged.
 */
public suspend inline fun SsmContactsClient.listPageReceipts(crossinline block: ListPageReceiptsRequest.Builder.() -> Unit): ListPageReceiptsResponse = listPageReceipts(ListPageReceiptsRequest.Builder().apply(block).build())

/**
 * Lists the engagements to a contact's contact channels.
 */
public suspend inline fun SsmContactsClient.listPagesByContact(crossinline block: ListPagesByContactRequest.Builder.() -> Unit): ListPagesByContactResponse = listPagesByContact(ListPagesByContactRequest.Builder().apply(block).build())

/**
 * Lists the engagements to contact channels that occurred by engaging a contact.
 */
public suspend inline fun SsmContactsClient.listPagesByEngagement(crossinline block: ListPagesByEngagementRequest.Builder.() -> Unit): ListPagesByEngagementResponse = listPagesByEngagement(ListPagesByEngagementRequest.Builder().apply(block).build())

/**
 * Lists the tags of an escalation plan or contact.
 */
public suspend inline fun SsmContactsClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Adds a resource policy to the specified contact or escalation plan. The resource policy is used to share the contact or escalation plan using Resource Access Manager (RAM). For more information about cross-account sharing, see [Setting up cross-account functionality](https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html).
 */
public suspend inline fun SsmContactsClient.putContactPolicy(crossinline block: PutContactPolicyRequest.Builder.() -> Unit): PutContactPolicyResponse = putContactPolicy(PutContactPolicyRequest.Builder().apply(block).build())

/**
 * Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in the console or with the `ActivateChannel` operation. Incident Manager can't engage a contact channel until it has been activated.
 */
public suspend inline fun SsmContactsClient.sendActivationCode(crossinline block: SendActivationCodeRequest.Builder.() -> Unit): SendActivationCodeResponse = sendActivationCode(SendActivationCodeRequest.Builder().apply(block).build())

/**
 * Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.
 */
public suspend inline fun SsmContactsClient.startEngagement(crossinline block: StartEngagementRequest.Builder.() -> Unit): StartEngagementResponse = startEngagement(StartEngagementRequest.Builder().apply(block).build())

/**
 * Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further contacts aren't engaged.
 */
public suspend inline fun SsmContactsClient.stopEngagement(crossinline block: StopEngagementRequest.Builder.() -> Unit): StopEngagementResponse = stopEngagement(StopEngagementRequest.Builder().apply(block).build())

/**
 * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your replication set.
 */
public suspend inline fun SsmContactsClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes tags from the specified resource.
 */
public suspend inline fun SsmContactsClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the contact or escalation plan specified.
 */
public suspend inline fun SsmContactsClient.updateContact(crossinline block: UpdateContactRequest.Builder.() -> Unit): UpdateContactResponse = updateContact(UpdateContactRequest.Builder().apply(block).build())

/**
 * Updates a contact's contact channel.
 */
public suspend inline fun SsmContactsClient.updateContactChannel(crossinline block: UpdateContactChannelRequest.Builder.() -> Unit): UpdateContactChannelResponse = updateContactChannel(UpdateContactChannelRequest.Builder().apply(block).build())
