// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts.paginators

import aws.sdk.kotlin.services.ssmcontacts.SsmContactsClient
import aws.sdk.kotlin.services.ssmcontacts.model.Contact
import aws.sdk.kotlin.services.ssmcontacts.model.ContactChannel
import aws.sdk.kotlin.services.ssmcontacts.model.Engagement
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactChannelsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactChannelsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListContactsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListEngagementsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListEngagementsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPageReceiptsRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPageReceiptsResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByContactRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByContactResponse
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByEngagementRequest
import aws.sdk.kotlin.services.ssmcontacts.model.ListPagesByEngagementResponse
import aws.sdk.kotlin.services.ssmcontacts.model.Page
import aws.sdk.kotlin.services.ssmcontacts.model.Receipt
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListContactChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContactChannelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactChannelsResponse]
 */
public fun SsmContactsClient.listContactChannelsPaginated(initialRequest: ListContactChannelsRequest): Flow<ListContactChannelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContactChannelsPaginated.listContactChannels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListContactChannelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactChannelsResponse]
 */
public fun SsmContactsClient.listContactChannelsPaginated(block: ListContactChannelsRequest.Builder.() -> Unit): Flow<ListContactChannelsResponse> =
    listContactChannelsPaginated(ListContactChannelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listContactChannelsPaginated]
 * to access the nested member [ContactChannel]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ContactChannel]
 */
@JvmName("listContactChannelsResponseContactChannel")
public fun Flow<ListContactChannelsResponse>.contactChannels(): Flow<ContactChannel> =
    transform() { response ->
        response.contactChannels?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListContactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListContactsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactsResponse]
 */
public fun SsmContactsClient.listContactsPaginated(initialRequest: ListContactsRequest): Flow<ListContactsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listContactsPaginated.listContacts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListContactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListContactsResponse]
 */
public fun SsmContactsClient.listContactsPaginated(block: ListContactsRequest.Builder.() -> Unit): Flow<ListContactsResponse> =
    listContactsPaginated(ListContactsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listContactsPaginated]
 * to access the nested member [Contact]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Contact]
 */
@JvmName("listContactsResponseContact")
public fun Flow<ListContactsResponse>.contacts(): Flow<Contact> =
    transform() { response ->
        response.contacts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEngagementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEngagementsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEngagementsResponse]
 */
public fun SsmContactsClient.listEngagementsPaginated(initialRequest: ListEngagementsRequest): Flow<ListEngagementsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEngagementsPaginated.listEngagements(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEngagementsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEngagementsResponse]
 */
public fun SsmContactsClient.listEngagementsPaginated(block: ListEngagementsRequest.Builder.() -> Unit): Flow<ListEngagementsResponse> =
    listEngagementsPaginated(ListEngagementsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEngagementsPaginated]
 * to access the nested member [Engagement]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Engagement]
 */
@JvmName("listEngagementsResponseEngagement")
public fun Flow<ListEngagementsResponse>.engagements(): Flow<Engagement> =
    transform() { response ->
        response.engagements?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPageReceiptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPageReceiptsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPageReceiptsResponse]
 */
public fun SsmContactsClient.listPageReceiptsPaginated(initialRequest: ListPageReceiptsRequest): Flow<ListPageReceiptsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPageReceiptsPaginated.listPageReceipts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPageReceiptsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPageReceiptsResponse]
 */
public fun SsmContactsClient.listPageReceiptsPaginated(block: ListPageReceiptsRequest.Builder.() -> Unit): Flow<ListPageReceiptsResponse> =
    listPageReceiptsPaginated(ListPageReceiptsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPageReceiptsPaginated]
 * to access the nested member [Receipt]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Receipt]
 */
@JvmName("listPageReceiptsResponseReceipt")
public fun Flow<ListPageReceiptsResponse>.receipts(): Flow<Receipt> =
    transform() { response ->
        response.receipts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPagesByContactResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPagesByContactRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPagesByContactResponse]
 */
public fun SsmContactsClient.listPagesByContactPaginated(initialRequest: ListPagesByContactRequest): Flow<ListPagesByContactResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPagesByContactPaginated.listPagesByContact(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPagesByContactResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPagesByContactResponse]
 */
public fun SsmContactsClient.listPagesByContactPaginated(block: ListPagesByContactRequest.Builder.() -> Unit): Flow<ListPagesByContactResponse> =
    listPagesByContactPaginated(ListPagesByContactRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPagesByContactPaginated]
 * to access the nested member [Page]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Page]
 */
@JvmName("listPagesByContactResponsePage")
public fun Flow<ListPagesByContactResponse>.pages(): Flow<Page> =
    transform() { response ->
        response.pages?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPagesByEngagementResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPagesByEngagementRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPagesByEngagementResponse]
 */
public fun SsmContactsClient.listPagesByEngagementPaginated(initialRequest: ListPagesByEngagementRequest): Flow<ListPagesByEngagementResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPagesByEngagementPaginated.listPagesByEngagement(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListPagesByEngagementResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPagesByEngagementResponse]
 */
public fun SsmContactsClient.listPagesByEngagementPaginated(block: ListPagesByEngagementRequest.Builder.() -> Unit): Flow<ListPagesByEngagementResponse> =
    listPagesByEngagementPaginated(ListPagesByEngagementRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPagesByEngagementPaginated]
 * to access the nested member [Page]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Page]
 */
@JvmName("listPagesByEngagementResponsePage")
public fun Flow<ListPagesByEngagementResponse>.pages(): Flow<Page> =
    transform() { response ->
        response.pages?.forEach {
            emit(it)
        }
    }
