// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssmcontacts

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.ssmcontacts.model.*
import aws.sdk.kotlin.services.ssmcontacts.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "SSM Contacts"
public const val ServiceApiVersion: String = "2021-05-03"
public const val SdkVersion: String = "0.17.9-beta"

internal class DefaultSsmContactsClient(override val config: SsmContactsClient.Config) : SsmContactsClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Used to acknowledge an engagement to a contact channel during an incident.
     */
    override suspend fun acceptPage(input: AcceptPageRequest): AcceptPageResponse {
        val op = SdkHttpOperation.build<AcceptPageRequest, AcceptPageResponse> {
            serializer = AcceptPageOperationSerializer()
            deserializer = AcceptPageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptPage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Activates a contact's contact channel. Incident Manager can't engage a contact until the contact channel has been activated.
     */
    override suspend fun activateContactChannel(input: ActivateContactChannelRequest): ActivateContactChannelResponse {
        val op = SdkHttpOperation.build<ActivateContactChannelRequest, ActivateContactChannelResponse> {
            serializer = ActivateContactChannelOperationSerializer()
            deserializer = ActivateContactChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ActivateContactChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident.
     */
    override suspend fun createContact(input: CreateContactRequest): CreateContactResponse {
        val op = SdkHttpOperation.build<CreateContactRequest, CreateContactResponse> {
            serializer = CreateContactOperationSerializer()
            deserializer = CreateContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * A contact channel is the method that Incident Manager uses to engage your contact.
     */
    override suspend fun createContactChannel(input: CreateContactChannelRequest): CreateContactChannelResponse {
        val op = SdkHttpOperation.build<CreateContactChannelRequest, CreateContactChannelResponse> {
            serializer = CreateContactChannelOperationSerializer()
            deserializer = CreateContactChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateContactChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel.
     */
    override suspend fun deactivateContactChannel(input: DeactivateContactChannelRequest): DeactivateContactChannelResponse {
        val op = SdkHttpOperation.build<DeactivateContactChannelRequest, DeactivateContactChannelResponse> {
            serializer = DeactivateContactChannelOperationSerializer()
            deserializer = DeactivateContactChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeactivateContactChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * To remove a contact from Incident Manager, you can delete the contact. Deleting a contact removes them from all escalation plans and related response plans. Deleting an escalation plan removes it from all related response plans. You will have to recreate the contact and its contact channels before you can use it again.
     */
    override suspend fun deleteContact(input: DeleteContactRequest): DeleteContactResponse {
        val op = SdkHttpOperation.build<DeleteContactRequest, DeleteContactResponse> {
            serializer = DeleteContactOperationSerializer()
            deserializer = DeleteContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * To no longer receive engagements on a contact channel, you can delete the channel from a contact. Deleting the contact channel removes it from the contact's engagement plan. If you delete the only contact channel for a contact, you won't be able to engage that contact during an incident.
     */
    override suspend fun deleteContactChannel(input: DeleteContactChannelRequest): DeleteContactChannelResponse {
        val op = SdkHttpOperation.build<DeleteContactChannelRequest, DeleteContactChannelResponse> {
            serializer = DeleteContactChannelOperationSerializer()
            deserializer = DeleteContactChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteContactChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Incident Manager uses engagements to engage contacts and escalation plans during an incident. Use this command to describe the engagement that occurred during an incident.
     */
    override suspend fun describeEngagement(input: DescribeEngagementRequest): DescribeEngagementResponse {
        val op = SdkHttpOperation.build<DescribeEngagementRequest, DescribeEngagementResponse> {
            serializer = DescribeEngagementOperationSerializer()
            deserializer = DescribeEngagementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEngagement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists details of the engagement to a contact channel.
     */
    override suspend fun describePage(input: DescribePageRequest): DescribePageResponse {
        val op = SdkHttpOperation.build<DescribePageRequest, DescribePageResponse> {
            serializer = DescribePageOperationSerializer()
            deserializer = DescribePageOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribePage"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves information about the specified contact or escalation plan.
     */
    override suspend fun getContact(input: GetContactRequest): GetContactResponse {
        val op = SdkHttpOperation.build<GetContactRequest, GetContactResponse> {
            serializer = GetContactOperationSerializer()
            deserializer = GetContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * List details about a specific contact channel.
     */
    override suspend fun getContactChannel(input: GetContactChannelRequest): GetContactChannelResponse {
        val op = SdkHttpOperation.build<GetContactChannelRequest, GetContactChannelResponse> {
            serializer = GetContactChannelOperationSerializer()
            deserializer = GetContactChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContactChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Retrieves the resource policies attached to the specified contact or escalation plan.
     */
    override suspend fun getContactPolicy(input: GetContactPolicyRequest): GetContactPolicyResponse {
        val op = SdkHttpOperation.build<GetContactPolicyRequest, GetContactPolicyResponse> {
            serializer = GetContactPolicyOperationSerializer()
            deserializer = GetContactPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetContactPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all contact channels for the specified contact.
     */
    override suspend fun listContactChannels(input: ListContactChannelsRequest): ListContactChannelsResponse {
        val op = SdkHttpOperation.build<ListContactChannelsRequest, ListContactChannelsResponse> {
            serializer = ListContactChannelsOperationSerializer()
            deserializer = ListContactChannelsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListContactChannels"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all contacts and escalation plans in Incident Manager.
     */
    override suspend fun listContacts(input: ListContactsRequest): ListContactsResponse {
        val op = SdkHttpOperation.build<ListContactsRequest, ListContactsResponse> {
            serializer = ListContactsOperationSerializer()
            deserializer = ListContactsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListContacts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all engagements that have happened in an incident.
     */
    override suspend fun listEngagements(input: ListEngagementsRequest): ListEngagementsResponse {
        val op = SdkHttpOperation.build<ListEngagementsRequest, ListEngagementsResponse> {
            serializer = ListEngagementsOperationSerializer()
            deserializer = ListEngagementsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEngagements"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists all of the engagements to contact channels that have been acknowledged.
     */
    override suspend fun listPageReceipts(input: ListPageReceiptsRequest): ListPageReceiptsResponse {
        val op = SdkHttpOperation.build<ListPageReceiptsRequest, ListPageReceiptsResponse> {
            serializer = ListPageReceiptsOperationSerializer()
            deserializer = ListPageReceiptsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPageReceipts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the engagements to a contact's contact channels.
     */
    override suspend fun listPagesByContact(input: ListPagesByContactRequest): ListPagesByContactResponse {
        val op = SdkHttpOperation.build<ListPagesByContactRequest, ListPagesByContactResponse> {
            serializer = ListPagesByContactOperationSerializer()
            deserializer = ListPagesByContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPagesByContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the engagements to contact channels that occurred by engaging a contact.
     */
    override suspend fun listPagesByEngagement(input: ListPagesByEngagementRequest): ListPagesByEngagementResponse {
        val op = SdkHttpOperation.build<ListPagesByEngagementRequest, ListPagesByEngagementResponse> {
            serializer = ListPagesByEngagementOperationSerializer()
            deserializer = ListPagesByEngagementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPagesByEngagement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the tags of an escalation plan or contact.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Adds a resource policy to the specified contact or escalation plan. The resource policy is used to share the contact or escalation plan using Resource Access Manager (RAM). For more information about cross-account sharing, see [Setting up cross-account functionality](https://docs.aws.amazon.com/incident-manager/latest/userguide/xa.html).
     */
    override suspend fun putContactPolicy(input: PutContactPolicyRequest): PutContactPolicyResponse {
        val op = SdkHttpOperation.build<PutContactPolicyRequest, PutContactPolicyResponse> {
            serializer = PutContactPolicyOperationSerializer()
            deserializer = PutContactPolicyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutContactPolicy"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Sends an activation code to a contact channel. The contact can use this code to activate the contact channel in the console or with the `ActivateChannel` operation. Incident Manager can't engage a contact channel until it has been activated.
     */
    override suspend fun sendActivationCode(input: SendActivationCodeRequest): SendActivationCodeResponse {
        val op = SdkHttpOperation.build<SendActivationCodeRequest, SendActivationCodeResponse> {
            serializer = SendActivationCodeOperationSerializer()
            deserializer = SendActivationCodeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SendActivationCode"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts an engagement to a contact or escalation plan. The engagement engages each contact specified in the incident.
     */
    override suspend fun startEngagement(input: StartEngagementRequest): StartEngagementResponse {
        val op = SdkHttpOperation.build<StartEngagementRequest, StartEngagementResponse> {
            serializer = StartEngagementOperationSerializer()
            deserializer = StartEngagementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartEngagement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops an engagement before it finishes the final stage of the escalation plan or engagement plan. Further contacts aren't engaged.
     */
    override suspend fun stopEngagement(input: StopEngagementRequest): StopEngagementResponse {
        val op = SdkHttpOperation.build<StopEngagementRequest, StopEngagementResponse> {
            serializer = StopEngagementOperationSerializer()
            deserializer = StopEngagementOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopEngagement"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tags a contact or escalation plan. You can tag only contacts and escalation plans in the first region of your replication set.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Removes tags from the specified resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates the contact or escalation plan specified.
     */
    override suspend fun updateContact(input: UpdateContactRequest): UpdateContactResponse {
        val op = SdkHttpOperation.build<UpdateContactRequest, UpdateContactResponse> {
            serializer = UpdateContactOperationSerializer()
            deserializer = UpdateContactOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateContact"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a contact's contact channel.
     */
    override suspend fun updateContactChannel(input: UpdateContactChannelRequest): UpdateContactChannelResponse {
        val op = SdkHttpOperation.build<UpdateContactChannelRequest, UpdateContactChannelResponse> {
            serializer = UpdateContactChannelOperationSerializer()
            deserializer = UpdateContactChannelOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateContactChannel"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(AwsJsonProtocol("SSMContacts", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "ssm-contacts"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "ssm-contacts")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
