// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.AccountSharingInfo
import aws.sdk.kotlin.services.ssm.model.DescribeDocumentPermissionResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class DescribeDocumentPermissionOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDocumentPermissionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDocumentPermissionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDocumentPermissionError(context, call, payload)
        }
        val builder = DescribeDocumentPermissionResponse.Builder()

        if (payload != null) {
            deserializeDescribeDocumentPermissionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDocumentPermissionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocument" -> InvalidDocumentDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidDocumentOperation" -> InvalidDocumentOperationDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidNextToken" -> InvalidNextTokenDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidPermissionType" -> InvalidPermissionTypeDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDocumentPermissionOperationBody(builder: DescribeDocumentPermissionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCOUNTIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AccountIds"))
    val ACCOUNTSHARINGINFOLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("AccountSharingInfoList"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCOUNTIDS_DESCRIPTOR)
        field(ACCOUNTSHARINGINFOLIST_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCOUNTIDS_DESCRIPTOR.index -> builder.accountIds =
                    deserializer.deserializeList(ACCOUNTIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ACCOUNTSHARINGINFOLIST_DESCRIPTOR.index -> builder.accountSharingInfoList =
                    deserializer.deserializeList(ACCOUNTSHARINGINFOLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<AccountSharingInfo>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAccountSharingInfoDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
