// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The filters to describe or get information about your managed nodes.
 */
public class InstanceInformationStringFilter private constructor(builder: Builder) {
    /**
     * The filter key name to describe your managed nodes.
     *
     * Valid filter key values: ActivationIds | AgentVersion | AssociationStatus | IamRole | InstanceIds | PingStatus | PlatformType | ResourceType | SourceIds | SourceTypes | "tag-key" | "tag:`{keyname}`
     * + Valid values for the `AssociationStatus` filter key: Success | Pending | Failed
     * + Valid values for the `PingStatus` filter key: Online | ConnectionLost | Inactive (deprecated)
     * + Valid values for the `PlatformType` filter key: Windows | Linux | MacOS
     * + Valid values for the `ResourceType` filter key: EC2Instance | ManagedInstance
     * + Valid values for the `SourceType` filter key: AWS::EC2::Instance | AWS::SSM::ManagedInstance | AWS::IoT::Thing
     * + Valid tag examples: `Key=tag-key,Values=Purpose` | `Key=tag:Purpose,Values=Test`.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The filter values.
     */
    public val values: List<String> = requireNotNull(builder.values) { "A non-null value must be provided for values" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InstanceInformationStringFilter = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InstanceInformationStringFilter(")
        append("key=$key,")
        append("values=$values")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = key.hashCode()
        result = 31 * result + (values.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InstanceInformationStringFilter

        if (key != other.key) return false
        if (values != other.values) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InstanceInformationStringFilter = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The filter key name to describe your managed nodes.
         *
         * Valid filter key values: ActivationIds | AgentVersion | AssociationStatus | IamRole | InstanceIds | PingStatus | PlatformType | ResourceType | SourceIds | SourceTypes | "tag-key" | "tag:`{keyname}`
         * + Valid values for the `AssociationStatus` filter key: Success | Pending | Failed
         * + Valid values for the `PingStatus` filter key: Online | ConnectionLost | Inactive (deprecated)
         * + Valid values for the `PlatformType` filter key: Windows | Linux | MacOS
         * + Valid values for the `ResourceType` filter key: EC2Instance | ManagedInstance
         * + Valid values for the `SourceType` filter key: AWS::EC2::Instance | AWS::SSM::ManagedInstance | AWS::IoT::Thing
         * + Valid tag examples: `Key=tag-key,Values=Purpose` | `Key=tag:Purpose,Values=Test`.
         */
        public var key: kotlin.String? = null
        /**
         * The filter values.
         */
        public var values: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InstanceInformationStringFilter) : this() {
            this.key = x.key
            this.values = x.values
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InstanceInformationStringFilter = InstanceInformationStringFilter(this)

        internal fun correctErrors(): Builder {
            if (key == null) key = ""
            if (values == null) values = emptyList()
            return this
        }
    }
}
