// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.AlarmConfiguration
import aws.sdk.kotlin.services.ssm.model.CloudWatchOutputConfig
import aws.sdk.kotlin.services.ssm.model.DocumentHashType
import aws.sdk.kotlin.services.ssm.model.NotificationConfig
import aws.sdk.kotlin.services.ssm.model.SendCommandRequest
import aws.sdk.kotlin.services.ssm.model.Target
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendCommandOperationSerializer: HttpSerializer.NonStreaming<SendCommandRequest> {
    override fun serialize(context: ExecutionContext, input: SendCommandRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeSendCommandOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeSendCommandOperationBody(context: ExecutionContext, input: SendCommandRequest): ByteArray {
    val serializer = JsonSerializer()
    val ALARMCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AlarmConfiguration"))
    val CLOUDWATCHOUTPUTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CloudWatchOutputConfig"))
    val COMMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Comment"))
    val DOCUMENTHASH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentHash"))
    val DOCUMENTHASHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DocumentHashType"))
    val DOCUMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentName"))
    val DOCUMENTVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DocumentVersion"))
    val INSTANCEIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("InstanceIds"))
    val MAXCONCURRENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MaxConcurrency"))
    val MAXERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MaxErrors"))
    val NOTIFICATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("NotificationConfig"))
    val OUTPUTS3BUCKETNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputS3BucketName"))
    val OUTPUTS3KEYPREFIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputS3KeyPrefix"))
    val OUTPUTS3REGION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputS3Region"))
    val PARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Parameters"))
    val PARAMETERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SERVICEROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceRoleArn"))
    val TARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Targets"))
    val TIMEOUTSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("TimeoutSeconds"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMCONFIGURATION_DESCRIPTOR)
        field(CLOUDWATCHOUTPUTCONFIG_DESCRIPTOR)
        field(COMMENT_DESCRIPTOR)
        field(DOCUMENTHASH_DESCRIPTOR)
        field(DOCUMENTHASHTYPE_DESCRIPTOR)
        field(DOCUMENTNAME_DESCRIPTOR)
        field(DOCUMENTVERSION_DESCRIPTOR)
        field(INSTANCEIDS_DESCRIPTOR)
        field(MAXCONCURRENCY_DESCRIPTOR)
        field(MAXERRORS_DESCRIPTOR)
        field(NOTIFICATIONCONFIG_DESCRIPTOR)
        field(OUTPUTS3BUCKETNAME_DESCRIPTOR)
        field(OUTPUTS3KEYPREFIX_DESCRIPTOR)
        field(OUTPUTS3REGION_DESCRIPTOR)
        field(PARAMETERS_DESCRIPTOR)
        field(SERVICEROLEARN_DESCRIPTOR)
        field(TARGETS_DESCRIPTOR)
        field(TIMEOUTSECONDS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.alarmConfiguration?.let { field(ALARMCONFIGURATION_DESCRIPTOR, it, ::serializeAlarmConfigurationDocument) }
        input.cloudWatchOutputConfig?.let { field(CLOUDWATCHOUTPUTCONFIG_DESCRIPTOR, it, ::serializeCloudWatchOutputConfigDocument) }
        input.comment?.let { field(COMMENT_DESCRIPTOR, it) }
        input.documentHash?.let { field(DOCUMENTHASH_DESCRIPTOR, it) }
        input.documentHashType?.let { field(DOCUMENTHASHTYPE_DESCRIPTOR, it.value) }
        input.documentName?.let { field(DOCUMENTNAME_DESCRIPTOR, it) }
        input.documentVersion?.let { field(DOCUMENTVERSION_DESCRIPTOR, it) }
        if (input.instanceIds != null) {
            listField(INSTANCEIDS_DESCRIPTOR) {
                for (el0 in input.instanceIds) {
                    serializeString(el0)
                }
            }
        }
        input.maxConcurrency?.let { field(MAXCONCURRENCY_DESCRIPTOR, it) }
        input.maxErrors?.let { field(MAXERRORS_DESCRIPTOR, it) }
        input.notificationConfig?.let { field(NOTIFICATIONCONFIG_DESCRIPTOR, it, ::serializeNotificationConfigDocument) }
        input.outputS3BucketName?.let { field(OUTPUTS3BUCKETNAME_DESCRIPTOR, it) }
        input.outputS3KeyPrefix?.let { field(OUTPUTS3KEYPREFIX_DESCRIPTOR, it) }
        input.outputS3Region?.let { field(OUTPUTS3REGION_DESCRIPTOR, it) }
        if (input.parameters != null) {
            mapField(PARAMETERS_DESCRIPTOR) {
                input.parameters.forEach { (key, value) ->
                    listEntry(key, PARAMETERS_C0_DESCRIPTOR) {
                        for (el1 in value) {
                            serializeString(el1)
                        }
                    }
                }
            }
        }
        input.serviceRoleArn?.let { field(SERVICEROLEARN_DESCRIPTOR, it) }
        if (input.targets != null) {
            listField(TARGETS_DESCRIPTOR) {
                for (el0 in input.targets) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTargetDocument))
                }
            }
        }
        input.timeoutSeconds?.let { field(TIMEOUTSECONDS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
