// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The combination of Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Automation execution.
 */
public class TargetLocation private constructor(builder: Builder) {
    /**
     * The Amazon Web Services accounts targeted by the current Automation execution.
     */
    public val accounts: List<String>? = builder.accounts
    /**
     * Amazon Web Services accounts or organizational units to exclude as expanded targets.
     */
    public val excludeAccounts: List<String>? = builder.excludeAccounts
    /**
     * The Automation execution role used by the currently running Automation. If not specified, the default value is `AWS-SystemsManager-AutomationExecutionRole`.
     */
    public val executionRoleName: kotlin.String? = builder.executionRoleName
    /**
     * Indicates whether to include child organizational units (OUs) that are children of the targeted OUs. The default is `false`.
     */
    public val includeChildOrganizationUnits: kotlin.Boolean = builder.includeChildOrganizationUnits
    /**
     * The Amazon Web Services Regions targeted by the current Automation execution.
     */
    public val regions: List<String>? = builder.regions
    /**
     * The details for the CloudWatch alarm you want to apply to an automation or command.
     */
    public val targetLocationAlarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.targetLocationAlarmConfiguration
    /**
     * The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation concurrently.
     */
    public val targetLocationMaxConcurrency: kotlin.String? = builder.targetLocationMaxConcurrency
    /**
     * The maximum number of errors allowed before the system stops queueing additional Automation executions for the currently running Automation.
     */
    public val targetLocationMaxErrors: kotlin.String? = builder.targetLocationMaxErrors
    /**
     * A list of key-value mappings to target resources. If you specify values for this data type, you must also specify a value for `TargetParameterName`.
     *
     * This `Targets` parameter takes precedence over the `StartAutomationExecution:Targets` parameter if both are supplied.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The maximum number of targets allowed to run this task in parallel. This `TargetsMaxConcurrency` takes precedence over the `StartAutomationExecution:MaxConcurrency` parameter if both are supplied.
     */
    public val targetsMaxConcurrency: kotlin.String? = builder.targetsMaxConcurrency
    /**
     * The maximum number of errors that are allowed before the system stops running the automation on additional targets. This `TargetsMaxErrors` parameter takes precedence over the `StartAutomationExecution:MaxErrors` parameter if both are supplied.
     */
    public val targetsMaxErrors: kotlin.String? = builder.targetsMaxErrors

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.TargetLocation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TargetLocation(")
        append("accounts=$accounts,")
        append("excludeAccounts=$excludeAccounts,")
        append("executionRoleName=$executionRoleName,")
        append("includeChildOrganizationUnits=$includeChildOrganizationUnits,")
        append("regions=$regions,")
        append("targetLocationAlarmConfiguration=$targetLocationAlarmConfiguration,")
        append("targetLocationMaxConcurrency=$targetLocationMaxConcurrency,")
        append("targetLocationMaxErrors=$targetLocationMaxErrors,")
        append("targets=$targets,")
        append("targetsMaxConcurrency=$targetsMaxConcurrency,")
        append("targetsMaxErrors=$targetsMaxErrors")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accounts?.hashCode() ?: 0
        result = 31 * result + (excludeAccounts?.hashCode() ?: 0)
        result = 31 * result + (executionRoleName?.hashCode() ?: 0)
        result = 31 * result + (includeChildOrganizationUnits.hashCode())
        result = 31 * result + (regions?.hashCode() ?: 0)
        result = 31 * result + (targetLocationAlarmConfiguration?.hashCode() ?: 0)
        result = 31 * result + (targetLocationMaxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (targetLocationMaxErrors?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        result = 31 * result + (targetsMaxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (targetsMaxErrors?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TargetLocation

        if (accounts != other.accounts) return false
        if (excludeAccounts != other.excludeAccounts) return false
        if (executionRoleName != other.executionRoleName) return false
        if (includeChildOrganizationUnits != other.includeChildOrganizationUnits) return false
        if (regions != other.regions) return false
        if (targetLocationAlarmConfiguration != other.targetLocationAlarmConfiguration) return false
        if (targetLocationMaxConcurrency != other.targetLocationMaxConcurrency) return false
        if (targetLocationMaxErrors != other.targetLocationMaxErrors) return false
        if (targets != other.targets) return false
        if (targetsMaxConcurrency != other.targetsMaxConcurrency) return false
        if (targetsMaxErrors != other.targetsMaxErrors) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.TargetLocation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services accounts targeted by the current Automation execution.
         */
        public var accounts: List<String>? = null
        /**
         * Amazon Web Services accounts or organizational units to exclude as expanded targets.
         */
        public var excludeAccounts: List<String>? = null
        /**
         * The Automation execution role used by the currently running Automation. If not specified, the default value is `AWS-SystemsManager-AutomationExecutionRole`.
         */
        public var executionRoleName: kotlin.String? = null
        /**
         * Indicates whether to include child organizational units (OUs) that are children of the targeted OUs. The default is `false`.
         */
        public var includeChildOrganizationUnits: kotlin.Boolean = false
        /**
         * The Amazon Web Services Regions targeted by the current Automation execution.
         */
        public var regions: List<String>? = null
        /**
         * The details for the CloudWatch alarm you want to apply to an automation or command.
         */
        public var targetLocationAlarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * The maximum number of Amazon Web Services Regions and Amazon Web Services accounts allowed to run the Automation concurrently.
         */
        public var targetLocationMaxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors allowed before the system stops queueing additional Automation executions for the currently running Automation.
         */
        public var targetLocationMaxErrors: kotlin.String? = null
        /**
         * A list of key-value mappings to target resources. If you specify values for this data type, you must also specify a value for `TargetParameterName`.
         *
         * This `Targets` parameter takes precedence over the `StartAutomationExecution:Targets` parameter if both are supplied.
         */
        public var targets: List<Target>? = null
        /**
         * The maximum number of targets allowed to run this task in parallel. This `TargetsMaxConcurrency` takes precedence over the `StartAutomationExecution:MaxConcurrency` parameter if both are supplied.
         */
        public var targetsMaxConcurrency: kotlin.String? = null
        /**
         * The maximum number of errors that are allowed before the system stops running the automation on additional targets. This `TargetsMaxErrors` parameter takes precedence over the `StartAutomationExecution:MaxErrors` parameter if both are supplied.
         */
        public var targetsMaxErrors: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.TargetLocation) : this() {
            this.accounts = x.accounts
            this.excludeAccounts = x.excludeAccounts
            this.executionRoleName = x.executionRoleName
            this.includeChildOrganizationUnits = x.includeChildOrganizationUnits
            this.regions = x.regions
            this.targetLocationAlarmConfiguration = x.targetLocationAlarmConfiguration
            this.targetLocationMaxConcurrency = x.targetLocationMaxConcurrency
            this.targetLocationMaxErrors = x.targetLocationMaxErrors
            this.targets = x.targets
            this.targetsMaxConcurrency = x.targetsMaxConcurrency
            this.targetsMaxErrors = x.targetsMaxErrors
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.TargetLocation = TargetLocation(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun targetLocationAlarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.targetLocationAlarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
