// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about an Automation runbook used in a runbook workflow in Change Manager.
 *
 * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.
 */
public class Runbook private constructor(builder: Builder) {
    /**
     * The name of the Automation runbook used in a runbook workflow.
     */
    public val documentName: kotlin.String = requireNotNull(builder.documentName) { "A non-null value must be provided for documentName" }
    /**
     * The version of the Automation runbook used in a runbook workflow.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * The `MaxConcurrency` value specified by the user when the operation started, indicating the maximum number of resources that the runbook operation can run on at the same time.
     */
    public val maxConcurrency: kotlin.String? = builder.maxConcurrency
    /**
     * The `MaxErrors` value specified by the user when the execution started, indicating the maximum number of errors that can occur during the operation before the updates are stopped or rolled back.
     */
    public val maxErrors: kotlin.String? = builder.maxErrors
    /**
     * The key-value map of execution parameters, which were supplied when calling `StartChangeRequestExecution`.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Runbook operation.
     */
    public val targetLocations: List<TargetLocation>? = builder.targetLocations
    /**
     * A key-value mapping of runbook parameters to target resources. Both Targets and TargetMaps can't be specified together.
     */
    public val targetMaps: List<Map<String, List<String>>>? = builder.targetMaps
    /**
     * The name of the parameter used as the target resource for the rate-controlled runbook workflow. Required if you specify `Targets`.
     */
    public val targetParameterName: kotlin.String? = builder.targetParameterName
    /**
     * A key-value mapping to target resources that the runbook operation performs tasks on. Required if you specify `TargetParameterName`.
     */
    public val targets: List<Target>? = builder.targets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.Runbook = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Runbook(")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("maxConcurrency=$maxConcurrency,")
        append("maxErrors=$maxErrors,")
        append("parameters=$parameters,")
        append("targetLocations=$targetLocations,")
        append("targetMaps=$targetMaps,")
        append("targetParameterName=$targetParameterName,")
        append("targets=$targets")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentName.hashCode()
        result = 31 * result + (documentVersion?.hashCode() ?: 0)
        result = 31 * result + (maxConcurrency?.hashCode() ?: 0)
        result = 31 * result + (maxErrors?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (targetLocations?.hashCode() ?: 0)
        result = 31 * result + (targetMaps?.hashCode() ?: 0)
        result = 31 * result + (targetParameterName?.hashCode() ?: 0)
        result = 31 * result + (targets?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Runbook

        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (maxConcurrency != other.maxConcurrency) return false
        if (maxErrors != other.maxErrors) return false
        if (parameters != other.parameters) return false
        if (targetLocations != other.targetLocations) return false
        if (targetMaps != other.targetMaps) return false
        if (targetParameterName != other.targetParameterName) return false
        if (targets != other.targets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.Runbook = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the Automation runbook used in a runbook workflow.
         */
        public var documentName: kotlin.String? = null
        /**
         * The version of the Automation runbook used in a runbook workflow.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * The `MaxConcurrency` value specified by the user when the operation started, indicating the maximum number of resources that the runbook operation can run on at the same time.
         */
        public var maxConcurrency: kotlin.String? = null
        /**
         * The `MaxErrors` value specified by the user when the execution started, indicating the maximum number of errors that can occur during the operation before the updates are stopped or rolled back.
         */
        public var maxErrors: kotlin.String? = null
        /**
         * The key-value map of execution parameters, which were supplied when calling `StartChangeRequestExecution`.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * Information about the Amazon Web Services Regions and Amazon Web Services accounts targeted by the current Runbook operation.
         */
        public var targetLocations: List<TargetLocation>? = null
        /**
         * A key-value mapping of runbook parameters to target resources. Both Targets and TargetMaps can't be specified together.
         */
        public var targetMaps: List<Map<String, List<String>>>? = null
        /**
         * The name of the parameter used as the target resource for the rate-controlled runbook workflow. Required if you specify `Targets`.
         */
        public var targetParameterName: kotlin.String? = null
        /**
         * A key-value mapping to target resources that the runbook operation performs tasks on. Required if you specify `TargetParameterName`.
         */
        public var targets: List<Target>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.Runbook) : this() {
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.maxConcurrency = x.maxConcurrency
            this.maxErrors = x.maxErrors
            this.parameters = x.parameters
            this.targetLocations = x.targetLocations
            this.targetMaps = x.targetMaps
            this.targetParameterName = x.targetParameterName
            this.targets = x.targets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.Runbook = Runbook(this)

        internal fun correctErrors(): Builder {
            if (documentName == null) documentName = ""
            return this
        }
    }
}
