// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configurations for sending notifications.
 */
public class NotificationConfig private constructor(builder: Builder) {
    /**
     * An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run Command pushes notifications about command status changes to this topic.
     */
    public val notificationArn: kotlin.String? = builder.notificationArn
    /**
     * The different events for which you can receive notifications. To learn more about these events, see [Monitoring Systems Manager status changes using Amazon SNS notifications](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val notificationEvents: List<NotificationEvent>? = builder.notificationEvents
    /**
     * The type of notification.
     * + `Command`: Receive notification when the status of a command changes.
     * + `Invocation`: For commands sent to multiple managed nodes, receive notification on a per-node basis when the status of a command changes.
     */
    public val notificationType: aws.sdk.kotlin.services.ssm.model.NotificationType? = builder.notificationType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.NotificationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NotificationConfig(")
        append("notificationArn=$notificationArn,")
        append("notificationEvents=$notificationEvents,")
        append("notificationType=$notificationType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = notificationArn?.hashCode() ?: 0
        result = 31 * result + (notificationEvents?.hashCode() ?: 0)
        result = 31 * result + (notificationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NotificationConfig

        if (notificationArn != other.notificationArn) return false
        if (notificationEvents != other.notificationEvents) return false
        if (notificationType != other.notificationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.NotificationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An Amazon Resource Name (ARN) for an Amazon Simple Notification Service (Amazon SNS) topic. Run Command pushes notifications about command status changes to this topic.
         */
        public var notificationArn: kotlin.String? = null
        /**
         * The different events for which you can receive notifications. To learn more about these events, see [Monitoring Systems Manager status changes using Amazon SNS notifications](https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var notificationEvents: List<NotificationEvent>? = null
        /**
         * The type of notification.
         * + `Command`: Receive notification when the status of a command changes.
         * + `Invocation`: For commands sent to multiple managed nodes, receive notification on a per-node basis when the status of a command changes.
         */
        public var notificationType: aws.sdk.kotlin.services.ssm.model.NotificationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.NotificationConfig) : this() {
            this.notificationArn = x.notificationArn
            this.notificationEvents = x.notificationEvents
            this.notificationType = x.notificationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.NotificationConfig = NotificationConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
