// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.PutInventoryResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutInventoryOperationDeserializer: HttpDeserializer.NonStreaming<PutInventoryResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutInventoryResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutInventoryError(context, call, payload)
        }
        val builder = PutInventoryResponse.Builder()

        if (payload != null) {
            deserializePutInventoryOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutInventoryError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CustomSchemaCountLimitExceededException" -> CustomSchemaCountLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInstanceId" -> InvalidInstanceIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidInventoryItemContextException" -> InvalidInventoryItemContextExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidItemContentException" -> InvalidItemContentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidTypeNameException" -> InvalidTypeNameExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ItemContentMismatchException" -> ItemContentMismatchExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ItemSizeLimitExceededException" -> ItemSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SubTypeCountLimitExceededException" -> SubTypeCountLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TotalSizeLimitExceededException" -> TotalSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedInventoryItemContextException" -> UnsupportedInventoryItemContextExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedInventorySchemaVersionException" -> UnsupportedInventorySchemaVersionExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutInventoryOperationBody(builder: PutInventoryResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Message"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MESSAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                MESSAGE_DESCRIPTOR.index -> builder.message = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
