// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.PutComplianceItemsResponse
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class PutComplianceItemsOperationDeserializer: HttpDeserializer.NonStreaming<PutComplianceItemsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutComplianceItemsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutComplianceItemsError(context, call, payload)
        }
        val builder = PutComplianceItemsResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutComplianceItemsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ComplianceTypeCountLimitExceededException" -> ComplianceTypeCountLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidItemContentException" -> InvalidItemContentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidResourceId" -> InvalidResourceIdDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidResourceType" -> InvalidResourceTypeDeserializer().deserialize(context, wrappedCall, payload)
        "ItemSizeLimitExceededException" -> ItemSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "TotalSizeLimitExceededException" -> TotalSizeLimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
