// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.serde

import aws.sdk.kotlin.services.ssm.model.AlarmConfiguration
import aws.sdk.kotlin.services.ssm.model.AlarmStateInformation
import aws.sdk.kotlin.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
import aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus
import aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskParameterValueExpression
import aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType
import aws.sdk.kotlin.services.ssm.model.SsmException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetMaintenanceWindowExecutionTaskOperationDeserializer: HttpDeserializer.NonStreaming<GetMaintenanceWindowExecutionTaskResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetMaintenanceWindowExecutionTaskResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetMaintenanceWindowExecutionTaskError(context, call, payload)
        }
        val builder = GetMaintenanceWindowExecutionTaskResponse.Builder()

        if (payload != null) {
            deserializeGetMaintenanceWindowExecutionTaskOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetMaintenanceWindowExecutionTaskError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsmException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "DoesNotExistException" -> DoesNotExistExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerError" -> InternalServerErrorDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsmException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMaintenanceWindowExecutionTaskOperationBody(builder: GetMaintenanceWindowExecutionTaskResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ALARMCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AlarmConfiguration"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("EndTime"))
    val MAXCONCURRENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MaxConcurrency"))
    val MAXERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MaxErrors"))
    val PRIORITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("Priority"))
    val SERVICEROLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceRole"))
    val STARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("StartTime"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Status"))
    val STATUSDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("StatusDetails"))
    val TASKARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskArn"))
    val TASKEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TaskExecutionId"))
    val TASKPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TaskParameters"))
    val TASKPARAMETERS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map)
    val TRIGGEREDALARMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TriggeredAlarms"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("Type"))
    val WINDOWEXECUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("WindowExecutionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ALARMCONFIGURATION_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(MAXCONCURRENCY_DESCRIPTOR)
        field(MAXERRORS_DESCRIPTOR)
        field(PRIORITY_DESCRIPTOR)
        field(SERVICEROLE_DESCRIPTOR)
        field(STARTTIME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSDETAILS_DESCRIPTOR)
        field(TASKARN_DESCRIPTOR)
        field(TASKEXECUTIONID_DESCRIPTOR)
        field(TASKPARAMETERS_DESCRIPTOR)
        field(TRIGGEREDALARMS_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(WINDOWEXECUTIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ALARMCONFIGURATION_DESCRIPTOR.index -> builder.alarmConfiguration = deserializeAlarmConfigurationDocument(deserializer)
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                MAXCONCURRENCY_DESCRIPTOR.index -> builder.maxConcurrency = deserializeString()
                MAXERRORS_DESCRIPTOR.index -> builder.maxErrors = deserializeString()
                PRIORITY_DESCRIPTOR.index -> builder.priority = deserializeInt()
                SERVICEROLE_DESCRIPTOR.index -> builder.serviceRole = deserializeString()
                STARTTIME_DESCRIPTOR.index -> builder.startTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MaintenanceWindowExecutionStatus.fromValue(it) }
                STATUSDETAILS_DESCRIPTOR.index -> builder.statusDetails = deserializeString()
                TASKARN_DESCRIPTOR.index -> builder.taskArn = deserializeString()
                TASKEXECUTIONID_DESCRIPTOR.index -> builder.taskExecutionId = deserializeString()
                TASKPARAMETERS_DESCRIPTOR.index -> builder.taskParameters =
                    deserializer.deserializeList(TASKPARAMETERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Map<String, MaintenanceWindowTaskParameterValueExpression>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeMap(TASKPARAMETERS_C0_DESCRIPTOR) {
                                val map1 = mutableMapOf<String, MaintenanceWindowTaskParameterValueExpression>()
                                while (hasNextEntry()) {
                                    val k1 = key()
                                    val v1 = if (nextHasValue()) { deserializeMaintenanceWindowTaskParameterValueExpressionDocument(deserializer) } else { deserializeNull(); continue }
                                    map1[k1] = v1
                                }
                                map1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                TRIGGEREDALARMS_DESCRIPTOR.index -> builder.triggeredAlarms =
                    deserializer.deserializeList(TRIGGEREDALARMS_DESCRIPTOR) {
                        val col0 = mutableListOf<AlarmStateInformation>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAlarmStateInformationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { MaintenanceWindowTaskType.fromValue(it) }
                WINDOWEXECUTIONID_DESCRIPTOR.index -> builder.windowExecutionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
