// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request body of the UpdateServiceSetting API operation.
 */
public class UpdateServiceSettingRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the service setting to update. For example, `arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled`. The setting ID can be one of the following.
     * + `/ssm/appmanager/appmanager-enabled`
     * + `/ssm/automation/customer-script-log-destination`
     * + `/ssm/automation/customer-script-log-group-name`
     * + /ssm/automation/enable-adaptive-concurrency
     * + `/ssm/documents/console/public-sharing-permission`
     * + `/ssm/managed-instance/activation-tier`
     * + `/ssm/managed-instance/default-ec2-instance-management-role`
     * + `/ssm/opsinsights/opscenter`
     * + `/ssm/parameter-store/default-parameter-tier`
     * + `/ssm/parameter-store/high-throughput-enabled`
     *
     * Permissions to update the `/ssm/managed-instance/default-ec2-instance-management-role` setting should only be provided to administrators. Implement least privilege access when allowing individuals to configure or modify the Default Host Management Configuration.
     */
    public val settingId: kotlin.String? = builder.settingId
    /**
     * The new value to specify for the service setting. The following list specifies the available values for each setting.
     * + For `/ssm/appmanager/appmanager-enabled`, enter `True` or `False`.
     * + For `/ssm/automation/customer-script-log-destination`, enter `CloudWatch`.
     * + For `/ssm/automation/customer-script-log-group-name`, enter the name of an Amazon CloudWatch Logs log group.
     * + For `/ssm/documents/console/public-sharing-permission`, enter `Enable` or `Disable`.
     * + For `/ssm/managed-instance/activation-tier`, enter `standard` or `advanced`.
     * + For `/ssm/managed-instance/default-ec2-instance-management-role`, enter the name of an IAM role.
     * +  For `/ssm/opsinsights/opscenter`, enter `Enabled` or `Disabled`.
     * + For `/ssm/parameter-store/default-parameter-tier`, enter `Standard`, `Advanced`, or `Intelligent-Tiering`
     * + For `/ssm/parameter-store/high-throughput-enabled`, enter `true` or `false`.
     */
    public val settingValue: kotlin.String? = builder.settingValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateServiceSettingRequest(")
        append("settingId=$settingId,")
        append("settingValue=$settingValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = settingId?.hashCode() ?: 0
        result = 31 * result + (this.settingValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateServiceSettingRequest

        if (settingId != other.settingId) return false
        if (settingValue != other.settingValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the service setting to update. For example, `arn:aws:ssm:us-east-1:111122223333:servicesetting/ssm/parameter-store/high-throughput-enabled`. The setting ID can be one of the following.
         * + `/ssm/appmanager/appmanager-enabled`
         * + `/ssm/automation/customer-script-log-destination`
         * + `/ssm/automation/customer-script-log-group-name`
         * + /ssm/automation/enable-adaptive-concurrency
         * + `/ssm/documents/console/public-sharing-permission`
         * + `/ssm/managed-instance/activation-tier`
         * + `/ssm/managed-instance/default-ec2-instance-management-role`
         * + `/ssm/opsinsights/opscenter`
         * + `/ssm/parameter-store/default-parameter-tier`
         * + `/ssm/parameter-store/high-throughput-enabled`
         *
         * Permissions to update the `/ssm/managed-instance/default-ec2-instance-management-role` setting should only be provided to administrators. Implement least privilege access when allowing individuals to configure or modify the Default Host Management Configuration.
         */
        public var settingId: kotlin.String? = null
        /**
         * The new value to specify for the service setting. The following list specifies the available values for each setting.
         * + For `/ssm/appmanager/appmanager-enabled`, enter `True` or `False`.
         * + For `/ssm/automation/customer-script-log-destination`, enter `CloudWatch`.
         * + For `/ssm/automation/customer-script-log-group-name`, enter the name of an Amazon CloudWatch Logs log group.
         * + For `/ssm/documents/console/public-sharing-permission`, enter `Enable` or `Disable`.
         * + For `/ssm/managed-instance/activation-tier`, enter `standard` or `advanced`.
         * + For `/ssm/managed-instance/default-ec2-instance-management-role`, enter the name of an IAM role.
         * +  For `/ssm/opsinsights/opscenter`, enter `Enabled` or `Disabled`.
         * + For `/ssm/parameter-store/default-parameter-tier`, enter `Standard`, `Advanced`, or `Intelligent-Tiering`
         * + For `/ssm/parameter-store/high-throughput-enabled`, enter `true` or `false`.
         */
        public var settingValue: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest) : this() {
            this.settingId = x.settingId
            this.settingValue = x.settingValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdateServiceSettingRequest = UpdateServiceSettingRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
