// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdatePatchBaselineRequest private constructor(builder: Builder) {
    /**
     * A set of rules used to include patches in the baseline.
     */
    public val approvalRules: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup? = builder.approvalRules
    /**
     * A list of explicitly approved patches for the baseline.
     *
     * For information about accepted formats for lists of approved patches and rejected patches, see [Package name formats for approved and rejected patch lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val approvedPatches: List<String>? = builder.approvedPatches
    /**
     * Assigns a new compliance severity level to an existing patch baseline.
     */
    public val approvedPatchesComplianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = builder.approvedPatchesComplianceLevel
    /**
     * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is `false`. Applies to Linux managed nodes only.
     */
    public val approvedPatchesEnableNonSecurity: kotlin.Boolean? = builder.approvedPatchesEnableNonSecurity
    /**
     * Indicates the status to be assigned to security patches that are available but not approved because they don't meet the installation criteria specified in the patch baseline.
     *
     * Example scenario: Security patches that you might want installed can be skipped if you have specified a long period to wait after a patch is released before installation. If an update to the patch is released during your specified waiting period, the waiting period for installing the patch starts over. If the waiting period is too long, multiple versions of the patch could be released but never installed.
     *
     * Supported for Windows Server managed nodes only.
     */
    public val availableSecurityUpdatesComplianceStatus: aws.sdk.kotlin.services.ssm.model.PatchComplianceStatus? = builder.availableSecurityUpdatesComplianceStatus
    /**
     * The ID of the patch baseline to update.
     */
    public val baselineId: kotlin.String? = builder.baselineId
    /**
     * A description of the patch baseline.
     */
    public val description: kotlin.String? = builder.description
    /**
     * A set of global filters used to include patches in the baseline.
     *
     * The `GlobalFilters` parameter can be configured only by using the CLI or an Amazon Web Services SDK. It can't be configured from the Patch Manager console, and its value isn't displayed in the console.
     */
    public val globalFilters: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = builder.globalFilters
    /**
     * The name of the patch baseline.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of explicitly rejected patches for the baseline.
     *
     * For information about accepted formats for lists of approved patches and rejected patches, see [Package name formats for approved and rejected patch lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val rejectedPatches: List<String>? = builder.rejectedPatches
    /**
     * The action for Patch Manager to take on patches included in the `RejectedPackages` list.
     *
     * ## ALLOW_AS_DEPENDENCY
     * **Linux and macOS**: A package in the rejected patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as `INSTALLED_OTHER`. This is the default action if no option is specified.
     *
     * **Windows Server**: Windows Server doesn't support the concept of package dependencies. If a package in the rejected patches list and already installed on the node, its status is reported as `INSTALLED_OTHER`. Any package not already installed on the node is skipped. This is the default action if no option is specified.
     *
     * ## BLOCK
     * **All OSs**: Packages in the rejected patches list, and packages that include them as dependencies, aren't installed by Patch Manager under any circumstances.
     *
     * State value assignment for patch compliance:
     * + If a package was installed before it was added to the rejected patches list, or is installed outside of Patch Manager afterward, it's considered noncompliant with the patch baseline and its status is reported as `INSTALLED_REJECTED`.
     * + If an update attempts to install a dependency package that is now rejected by the baseline, when previous versions of the package were not rejected, the package being updated is reported as `MISSING` for `SCAN` operations and as `FAILED` for `INSTALL` operations.
     */
    public val rejectedPatchesAction: aws.sdk.kotlin.services.ssm.model.PatchAction? = builder.rejectedPatchesAction
    /**
     * If True, then all fields that are required by the CreatePatchBaseline operation are also required for this API request. Optional fields that aren't specified are set to null.
     */
    public val replace: kotlin.Boolean? = builder.replace
    /**
     * Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.
     */
    public val sources: List<PatchSource>? = builder.sources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdatePatchBaselineRequest(")
        append("approvalRules=$approvalRules,")
        append("approvedPatches=$approvedPatches,")
        append("approvedPatchesComplianceLevel=$approvedPatchesComplianceLevel,")
        append("approvedPatchesEnableNonSecurity=$approvedPatchesEnableNonSecurity,")
        append("availableSecurityUpdatesComplianceStatus=$availableSecurityUpdatesComplianceStatus,")
        append("baselineId=$baselineId,")
        append("description=$description,")
        append("globalFilters=$globalFilters,")
        append("name=$name,")
        append("rejectedPatches=$rejectedPatches,")
        append("rejectedPatchesAction=$rejectedPatchesAction,")
        append("replace=$replace,")
        append("sources=$sources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = approvalRules?.hashCode() ?: 0
        result = 31 * result + (this.approvedPatches?.hashCode() ?: 0)
        result = 31 * result + (this.approvedPatchesComplianceLevel?.hashCode() ?: 0)
        result = 31 * result + (this.approvedPatchesEnableNonSecurity?.hashCode() ?: 0)
        result = 31 * result + (this.availableSecurityUpdatesComplianceStatus?.hashCode() ?: 0)
        result = 31 * result + (this.baselineId?.hashCode() ?: 0)
        result = 31 * result + (this.description?.hashCode() ?: 0)
        result = 31 * result + (this.globalFilters?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.rejectedPatches?.hashCode() ?: 0)
        result = 31 * result + (this.rejectedPatchesAction?.hashCode() ?: 0)
        result = 31 * result + (this.replace?.hashCode() ?: 0)
        result = 31 * result + (this.sources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdatePatchBaselineRequest

        if (approvalRules != other.approvalRules) return false
        if (approvedPatches != other.approvedPatches) return false
        if (approvedPatchesComplianceLevel != other.approvedPatchesComplianceLevel) return false
        if (approvedPatchesEnableNonSecurity != other.approvedPatchesEnableNonSecurity) return false
        if (availableSecurityUpdatesComplianceStatus != other.availableSecurityUpdatesComplianceStatus) return false
        if (baselineId != other.baselineId) return false
        if (description != other.description) return false
        if (globalFilters != other.globalFilters) return false
        if (name != other.name) return false
        if (rejectedPatches != other.rejectedPatches) return false
        if (rejectedPatchesAction != other.rejectedPatchesAction) return false
        if (replace != other.replace) return false
        if (sources != other.sources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A set of rules used to include patches in the baseline.
         */
        public var approvalRules: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup? = null
        /**
         * A list of explicitly approved patches for the baseline.
         *
         * For information about accepted formats for lists of approved patches and rejected patches, see [Package name formats for approved and rejected patch lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var approvedPatches: List<String>? = null
        /**
         * Assigns a new compliance severity level to an existing patch baseline.
         */
        public var approvedPatchesComplianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = null
        /**
         * Indicates whether the list of approved patches includes non-security updates that should be applied to the managed nodes. The default value is `false`. Applies to Linux managed nodes only.
         */
        public var approvedPatchesEnableNonSecurity: kotlin.Boolean? = null
        /**
         * Indicates the status to be assigned to security patches that are available but not approved because they don't meet the installation criteria specified in the patch baseline.
         *
         * Example scenario: Security patches that you might want installed can be skipped if you have specified a long period to wait after a patch is released before installation. If an update to the patch is released during your specified waiting period, the waiting period for installing the patch starts over. If the waiting period is too long, multiple versions of the patch could be released but never installed.
         *
         * Supported for Windows Server managed nodes only.
         */
        public var availableSecurityUpdatesComplianceStatus: aws.sdk.kotlin.services.ssm.model.PatchComplianceStatus? = null
        /**
         * The ID of the patch baseline to update.
         */
        public var baselineId: kotlin.String? = null
        /**
         * A description of the patch baseline.
         */
        public var description: kotlin.String? = null
        /**
         * A set of global filters used to include patches in the baseline.
         *
         * The `GlobalFilters` parameter can be configured only by using the CLI or an Amazon Web Services SDK. It can't be configured from the Patch Manager console, and its value isn't displayed in the console.
         */
        public var globalFilters: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = null
        /**
         * The name of the patch baseline.
         */
        public var name: kotlin.String? = null
        /**
         * A list of explicitly rejected patches for the baseline.
         *
         * For information about accepted formats for lists of approved patches and rejected patches, see [Package name formats for approved and rejected patch lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var rejectedPatches: List<String>? = null
        /**
         * The action for Patch Manager to take on patches included in the `RejectedPackages` list.
         *
         * ## ALLOW_AS_DEPENDENCY
         * **Linux and macOS**: A package in the rejected patches list is installed only if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is reported as `INSTALLED_OTHER`. This is the default action if no option is specified.
         *
         * **Windows Server**: Windows Server doesn't support the concept of package dependencies. If a package in the rejected patches list and already installed on the node, its status is reported as `INSTALLED_OTHER`. Any package not already installed on the node is skipped. This is the default action if no option is specified.
         *
         * ## BLOCK
         * **All OSs**: Packages in the rejected patches list, and packages that include them as dependencies, aren't installed by Patch Manager under any circumstances.
         *
         * State value assignment for patch compliance:
         * + If a package was installed before it was added to the rejected patches list, or is installed outside of Patch Manager afterward, it's considered noncompliant with the patch baseline and its status is reported as `INSTALLED_REJECTED`.
         * + If an update attempts to install a dependency package that is now rejected by the baseline, when previous versions of the package were not rejected, the package being updated is reported as `MISSING` for `SCAN` operations and as `FAILED` for `INSTALL` operations.
         */
        public var rejectedPatchesAction: aws.sdk.kotlin.services.ssm.model.PatchAction? = null
        /**
         * If True, then all fields that are required by the CreatePatchBaseline operation are also required for this API request. Optional fields that aren't specified are set to null.
         */
        public var replace: kotlin.Boolean? = null
        /**
         * Information about the patches to use to update the managed nodes, including target operating systems and source repositories. Applies to Linux managed nodes only.
         */
        public var sources: List<PatchSource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest) : this() {
            this.approvalRules = x.approvalRules
            this.approvedPatches = x.approvedPatches
            this.approvedPatchesComplianceLevel = x.approvedPatchesComplianceLevel
            this.approvedPatchesEnableNonSecurity = x.approvedPatchesEnableNonSecurity
            this.availableSecurityUpdatesComplianceStatus = x.availableSecurityUpdatesComplianceStatus
            this.baselineId = x.baselineId
            this.description = x.description
            this.globalFilters = x.globalFilters
            this.name = x.name
            this.rejectedPatches = x.rejectedPatches
            this.rejectedPatchesAction = x.rejectedPatchesAction
            this.replace = x.replace
            this.sources = x.sources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.UpdatePatchBaselineRequest = UpdatePatchBaselineRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchRuleGroup] inside the given [block]
         */
        public fun approvalRules(block: aws.sdk.kotlin.services.ssm.model.PatchRuleGroup.Builder.() -> kotlin.Unit) {
            this.approvalRules = aws.sdk.kotlin.services.ssm.model.PatchRuleGroup.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchFilterGroup] inside the given [block]
         */
        public fun globalFilters(block: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.Builder.() -> kotlin.Unit) {
            this.globalFilters = aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
