// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class StartSessionRequest private constructor(builder: Builder) {
    /**
     * The name of the SSM document you want to use to define the type of session, input parameters, or preferences for the session. For example, `SSM-SessionManagerRunShell`. You can call the GetDocument API to verify the document exists before attempting to start a session. If no document name is provided, a shell to the managed node is launched by default. For more information, see [Start a session](https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The values you want to specify for the parameters defined in the Session document. For more information about these parameters, see [Create a Session Manager preferences document](https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-preferences-cli.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * The reason for connecting to the instance. This value is included in the details for the Amazon CloudWatch Events event created when you start the session.
     */
    public val reason: kotlin.String? = builder.reason
    /**
     * The managed node to connect to for the session.
     */
    public val target: kotlin.String? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.StartSessionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSessionRequest(")
        append("documentName=$documentName,")
        append("parameters=$parameters,")
        append("reason=$reason,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = documentName?.hashCode() ?: 0
        result = 31 * result + (this.parameters?.hashCode() ?: 0)
        result = 31 * result + (this.reason?.hashCode() ?: 0)
        result = 31 * result + (this.target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSessionRequest

        if (documentName != other.documentName) return false
        if (parameters != other.parameters) return false
        if (reason != other.reason) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.StartSessionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the SSM document you want to use to define the type of session, input parameters, or preferences for the session. For example, `SSM-SessionManagerRunShell`. You can call the GetDocument API to verify the document exists before attempting to start a session. If no document name is provided, a shell to the managed node is launched by default. For more information, see [Start a session](https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-sessions-start.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var documentName: kotlin.String? = null
        /**
         * The values you want to specify for the parameters defined in the Session document. For more information about these parameters, see [Create a Session Manager preferences document](https://docs.aws.amazon.com/systems-manager/latest/userguide/getting-started-create-preferences-cli.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * The reason for connecting to the instance. This value is included in the details for the Amazon CloudWatch Events event created when you start the session.
         */
        public var reason: kotlin.String? = null
        /**
         * The managed node to connect to for the session.
         */
        public var target: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.StartSessionRequest) : this() {
            this.documentName = x.documentName
            this.parameters = x.parameters
            this.reason = x.reason
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.StartSessionRequest = StartSessionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
