// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class StartChangeRequestExecutionRequest private constructor(builder: Builder) {
    /**
     * Indicates whether the change request can be approved automatically without the need for manual approvals.
     *
     * If `AutoApprovable` is enabled in a change template, then setting `AutoApprove` to `true` in `StartChangeRequestExecution` creates a change request that bypasses approver review.
     *
     * Change Calendar restrictions are not bypassed in this scenario. If the state of an associated calendar is `CLOSED`, change freeze approvers must still grant permission for this change request to run. If they don't, the change won't be processed until the calendar state is again `OPEN`.
     */
    public val autoApprove: kotlin.Boolean? = builder.autoApprove
    /**
     * User-provided details about the change. If no details are provided, content specified in the **Template information** section of the associated change template is added.
     */
    public val changeDetails: kotlin.String? = builder.changeDetails
    /**
     * The name of the change request associated with the runbook workflow to be run.
     */
    public val changeRequestName: kotlin.String? = builder.changeRequestName
    /**
     * The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can't be reused.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the change template document to run during the runbook workflow.
     */
    public val documentName: kotlin.String? = builder.documentName
    /**
     * The version of the change template document to run during the runbook workflow.
     */
    public val documentVersion: kotlin.String? = builder.documentVersion
    /**
     * A key-value map of parameters that match the declared parameters in the change template document.
     */
    public val parameters: Map<String, List<String>>? = builder.parameters
    /**
     * Information about the Automation runbooks that are run during the runbook workflow.
     *
     * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.
     */
    public val runbooks: List<Runbook>? = builder.runbooks
    /**
     * The time that the requester expects the runbook workflow related to the change request to complete. The time is an estimate only that the requester provides for reviewers.
     */
    public val scheduledEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledEndTime
    /**
     * The date and time specified in the change request to run the Automation runbooks.
     *
     * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.
     */
    public val scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduledTime
    /**
     * Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a change request to identify an environment or target Amazon Web Services Region. In this case, you could specify the following key-value pairs:
     * + `Key=Environment,Value=Production`
     * + `Key=Region,Value=us-east-2`
     *
     * The `Array Members` maximum value is reported as 1000. This number includes capacity reserved for internal operations. When calling the `StartChangeRequestExecution` action, you can specify a maximum of 5 tags. You can, however, use the AddTagsToResource action to add up to a total of 50 tags to an existing change request configuration.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartChangeRequestExecutionRequest(")
        append("autoApprove=$autoApprove,")
        append("changeDetails=$changeDetails,")
        append("changeRequestName=$changeRequestName,")
        append("clientToken=$clientToken,")
        append("documentName=$documentName,")
        append("documentVersion=$documentVersion,")
        append("parameters=$parameters,")
        append("runbooks=$runbooks,")
        append("scheduledEndTime=$scheduledEndTime,")
        append("scheduledTime=$scheduledTime,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoApprove?.hashCode() ?: 0
        result = 31 * result + (this.changeDetails?.hashCode() ?: 0)
        result = 31 * result + (this.changeRequestName?.hashCode() ?: 0)
        result = 31 * result + (this.clientToken?.hashCode() ?: 0)
        result = 31 * result + (this.documentName?.hashCode() ?: 0)
        result = 31 * result + (this.documentVersion?.hashCode() ?: 0)
        result = 31 * result + (this.parameters?.hashCode() ?: 0)
        result = 31 * result + (this.runbooks?.hashCode() ?: 0)
        result = 31 * result + (this.scheduledEndTime?.hashCode() ?: 0)
        result = 31 * result + (this.scheduledTime?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartChangeRequestExecutionRequest

        if (autoApprove != other.autoApprove) return false
        if (changeDetails != other.changeDetails) return false
        if (changeRequestName != other.changeRequestName) return false
        if (clientToken != other.clientToken) return false
        if (documentName != other.documentName) return false
        if (documentVersion != other.documentVersion) return false
        if (parameters != other.parameters) return false
        if (runbooks != other.runbooks) return false
        if (scheduledEndTime != other.scheduledEndTime) return false
        if (scheduledTime != other.scheduledTime) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates whether the change request can be approved automatically without the need for manual approvals.
         *
         * If `AutoApprovable` is enabled in a change template, then setting `AutoApprove` to `true` in `StartChangeRequestExecution` creates a change request that bypasses approver review.
         *
         * Change Calendar restrictions are not bypassed in this scenario. If the state of an associated calendar is `CLOSED`, change freeze approvers must still grant permission for this change request to run. If they don't, the change won't be processed until the calendar state is again `OPEN`.
         */
        public var autoApprove: kotlin.Boolean? = null
        /**
         * User-provided details about the change. If no details are provided, content specified in the **Template information** section of the associated change template is added.
         */
        public var changeDetails: kotlin.String? = null
        /**
         * The name of the change request associated with the runbook workflow to be run.
         */
        public var changeRequestName: kotlin.String? = null
        /**
         * The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and can't be reused.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the change template document to run during the runbook workflow.
         */
        public var documentName: kotlin.String? = null
        /**
         * The version of the change template document to run during the runbook workflow.
         */
        public var documentVersion: kotlin.String? = null
        /**
         * A key-value map of parameters that match the declared parameters in the change template document.
         */
        public var parameters: Map<String, List<String>>? = null
        /**
         * Information about the Automation runbooks that are run during the runbook workflow.
         *
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.
         */
        public var runbooks: List<Runbook>? = null
        /**
         * The time that the requester expects the runbook workflow related to the change request to complete. The time is an estimate only that the requester provides for reviewers.
         */
        public var scheduledEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time specified in the change request to run the Automation runbooks.
         *
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change request have been received.
         */
        public var scheduledTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a change request to identify an environment or target Amazon Web Services Region. In this case, you could specify the following key-value pairs:
         * + `Key=Environment,Value=Production`
         * + `Key=Region,Value=us-east-2`
         *
         * The `Array Members` maximum value is reported as 1000. This number includes capacity reserved for internal operations. When calling the `StartChangeRequestExecution` action, you can specify a maximum of 5 tags. You can, however, use the AddTagsToResource action to add up to a total of 50 tags to an existing change request configuration.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest) : this() {
            this.autoApprove = x.autoApprove
            this.changeDetails = x.changeDetails
            this.changeRequestName = x.changeRequestName
            this.clientToken = x.clientToken
            this.documentName = x.documentName
            this.documentVersion = x.documentVersion
            this.parameters = x.parameters
            this.runbooks = x.runbooks
            this.scheduledEndTime = x.scheduledEndTime
            this.scheduledTime = x.scheduledTime
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.StartChangeRequestExecutionRequest = StartChangeRequestExecutionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
