// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The data type name for including resource data sync state. There are four sync states:
 *
 * `OrganizationNotExists` (Your organization doesn't exist)
 *
 * `NoPermissions` (The system can't locate the service-linked role. This role is automatically created when a user creates a resource data sync in Amazon Web Services Systems Manager Explorer.)
 *
 * `InvalidOrganizationalUnit` (You specified or selected an invalid unit in the resource data sync configuration.)
 *
 * `TrustedAccessDisabled` (You disabled Systems Manager access in the organization in Organizations.)
 */
public class ResourceDataSyncSourceWithState private constructor(builder: Builder) {
    /**
     * The field name in `SyncSource` for the `ResourceDataSyncAwsOrganizationsSource` type.
     */
    public val awsOrganizationsSource: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource? = builder.awsOrganizationsSource
    /**
     * When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in your organization (or in the selected organization units). For more information, see [Setting up Systems Manager Explorer to display data from multiple accounts and Regions](https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val enableAllOpsDataSources: kotlin.Boolean = builder.enableAllOpsDataSources
    /**
     * Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those Regions come online.
     */
    public val includeFutureRegions: kotlin.Boolean = builder.includeFutureRegions
    /**
     * The `SyncSource` Amazon Web Services Regions included in the resource data sync.
     */
    public val sourceRegions: List<String>? = builder.sourceRegions
    /**
     * The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in Organizations) or `singleAccountMultiRegions`.
     */
    public val sourceType: kotlin.String? = builder.sourceType
    /**
     * The data type name for including resource data sync state. There are four sync states:
     *
     * `OrganizationNotExists`: Your organization doesn't exist.
     *
     * `NoPermissions`: The system can't locate the service-linked role. This role is automatically created when a user creates a resource data sync in Explorer.
     *
     * `InvalidOrganizationalUnit`: You specified or selected an invalid unit in the resource data sync configuration.
     *
     * `TrustedAccessDisabled`: You disabled Systems Manager access in the organization in Organizations.
     */
    public val state: kotlin.String? = builder.state

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDataSyncSourceWithState(")
        append("awsOrganizationsSource=$awsOrganizationsSource,")
        append("enableAllOpsDataSources=$enableAllOpsDataSources,")
        append("includeFutureRegions=$includeFutureRegions,")
        append("sourceRegions=$sourceRegions,")
        append("sourceType=$sourceType,")
        append("state=$state")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsOrganizationsSource?.hashCode() ?: 0
        result = 31 * result + (this.enableAllOpsDataSources.hashCode())
        result = 31 * result + (this.includeFutureRegions.hashCode())
        result = 31 * result + (this.sourceRegions?.hashCode() ?: 0)
        result = 31 * result + (this.sourceType?.hashCode() ?: 0)
        result = 31 * result + (this.state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDataSyncSourceWithState

        if (awsOrganizationsSource != other.awsOrganizationsSource) return false
        if (enableAllOpsDataSources != other.enableAllOpsDataSources) return false
        if (includeFutureRegions != other.includeFutureRegions) return false
        if (sourceRegions != other.sourceRegions) return false
        if (sourceType != other.sourceType) return false
        if (state != other.state) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The field name in `SyncSource` for the `ResourceDataSyncAwsOrganizationsSource` type.
         */
        public var awsOrganizationsSource: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource? = null
        /**
         * When you create a resource data sync, if you choose one of the Organizations options, then Systems Manager automatically enables all OpsData sources in the selected Amazon Web Services Regions for all Amazon Web Services accounts in your organization (or in the selected organization units). For more information, see [Setting up Systems Manager Explorer to display data from multiple accounts and Regions](https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var enableAllOpsDataSources: kotlin.Boolean = false
        /**
         * Whether to automatically synchronize and aggregate data from new Amazon Web Services Regions when those Regions come online.
         */
        public var includeFutureRegions: kotlin.Boolean = false
        /**
         * The `SyncSource` Amazon Web Services Regions included in the resource data sync.
         */
        public var sourceRegions: List<String>? = null
        /**
         * The type of data source for the resource data sync. `SourceType` is either `AwsOrganizations` (if an organization is present in Organizations) or `singleAccountMultiRegions`.
         */
        public var sourceType: kotlin.String? = null
        /**
         * The data type name for including resource data sync state. There are four sync states:
         *
         * `OrganizationNotExists`: Your organization doesn't exist.
         *
         * `NoPermissions`: The system can't locate the service-linked role. This role is automatically created when a user creates a resource data sync in Explorer.
         *
         * `InvalidOrganizationalUnit`: You specified or selected an invalid unit in the resource data sync configuration.
         *
         * `TrustedAccessDisabled`: You disabled Systems Manager access in the organization in Organizations.
         */
        public var state: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState) : this() {
            this.awsOrganizationsSource = x.awsOrganizationsSource
            this.enableAllOpsDataSources = x.enableAllOpsDataSources
            this.includeFutureRegions = x.includeFutureRegions
            this.sourceRegions = x.sourceRegions
            this.sourceType = x.sourceType
            this.state = x.state
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncSourceWithState = ResourceDataSyncSourceWithState(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource] inside the given [block]
         */
        public fun awsOrganizationsSource(block: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource.Builder.() -> kotlin.Unit) {
            this.awsOrganizationsSource = aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
