// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the `AwsOrganizationsSource` resource data sync source. A sync source of this type can synchronize data from Organizations or, if an Amazon Web Services organization isn't present, from multiple Amazon Web Services Regions.
 */
public class ResourceDataSyncAwsOrganizationsSource private constructor(builder: Builder) {
    /**
     * If an Amazon Web Services organization is present, this is either `OrganizationalUnits` or `EntireOrganization`. For `OrganizationalUnits`, the data is aggregated from a set of organization units. For `EntireOrganization`, the data is aggregated from the entire Amazon Web Services organization.
     */
    public val organizationSourceType: kotlin.String = requireNotNull(builder.organizationSourceType) { "A non-null value must be provided for organizationSourceType" }
    /**
     * The Organizations organization units included in the sync.
     */
    public val organizationalUnits: List<ResourceDataSyncOrganizationalUnit>? = builder.organizationalUnits

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDataSyncAwsOrganizationsSource(")
        append("organizationSourceType=$organizationSourceType,")
        append("organizationalUnits=$organizationalUnits")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = organizationSourceType.hashCode()
        result = 31 * result + (this.organizationalUnits?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDataSyncAwsOrganizationsSource

        if (organizationSourceType != other.organizationSourceType) return false
        if (organizationalUnits != other.organizationalUnits) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If an Amazon Web Services organization is present, this is either `OrganizationalUnits` or `EntireOrganization`. For `OrganizationalUnits`, the data is aggregated from a set of organization units. For `EntireOrganization`, the data is aggregated from the entire Amazon Web Services organization.
         */
        public var organizationSourceType: kotlin.String? = null
        /**
         * The Organizations organization units included in the sync.
         */
        public var organizationalUnits: List<ResourceDataSyncOrganizationalUnit>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource) : this() {
            this.organizationSourceType = x.organizationSourceType
            this.organizationalUnits = x.organizationalUnits
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.ResourceDataSyncAwsOrganizationsSource = ResourceDataSyncAwsOrganizationsSource(this)

        internal fun correctErrors(): Builder {
            if (organizationSourceType == null) organizationSourceType = ""
            return this
        }
    }
}
