// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RemoveTagsFromResourceRequest private constructor(builder: Builder) {
    /**
     * The ID of the resource from which you want to remove tags. For example:
     *
     * ManagedInstance: mi-012345abcde
     *
     * MaintenanceWindow: mw-012345abcde
     *
     * `Automation`: `example-c160-4567-8519-012345abcde`
     *
     * PatchBaseline: pb-012345abcde
     *
     * OpsMetadata object: `ResourceID` for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, `ResourceID` is created from the strings that come after the word `opsmetadata` in the ARN. For example, an OpsMetadata object with an ARN of `arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager` has a `ResourceID` of either `aws/ssm/MyGroup/appmanager` or `/aws/ssm/MyGroup/appmanager`.
     *
     * For the Document and Parameter values, use the name of the resource.
     *
     * The `ManagedInstance` type for this API operation is only for on-premises managed nodes. Specify the name of the managed node in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The type of resource from which you want to remove a tag.
     *
     * The `ManagedInstance` type for this API operation is only for on-premises managed nodes. Specify the name of the managed node in the following format: `mi-<i>ID_number</i> `. For example, `mi-1a2b3c4d5e6f`.
     */
    public val resourceType: aws.sdk.kotlin.services.ssm.model.ResourceTypeForTagging? = builder.resourceType
    /**
     * Tag keys that you want to remove from the specified resource.
     */
    public val tagKeys: List<String>? = builder.tagKeys

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.RemoveTagsFromResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemoveTagsFromResourceRequest(")
        append("resourceId=$resourceId,")
        append("resourceType=$resourceType,")
        append("tagKeys=$tagKeys")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (this.resourceType?.hashCode() ?: 0)
        result = 31 * result + (this.tagKeys?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemoveTagsFromResourceRequest

        if (resourceId != other.resourceId) return false
        if (resourceType != other.resourceType) return false
        if (tagKeys != other.tagKeys) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.RemoveTagsFromResourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the resource from which you want to remove tags. For example:
         *
         * ManagedInstance: mi-012345abcde
         *
         * MaintenanceWindow: mw-012345abcde
         *
         * `Automation`: `example-c160-4567-8519-012345abcde`
         *
         * PatchBaseline: pb-012345abcde
         *
         * OpsMetadata object: `ResourceID` for tagging is created from the Amazon Resource Name (ARN) for the object. Specifically, `ResourceID` is created from the strings that come after the word `opsmetadata` in the ARN. For example, an OpsMetadata object with an ARN of `arn:aws:ssm:us-east-2:1234567890:opsmetadata/aws/ssm/MyGroup/appmanager` has a `ResourceID` of either `aws/ssm/MyGroup/appmanager` or `/aws/ssm/MyGroup/appmanager`.
         *
         * For the Document and Parameter values, use the name of the resource.
         *
         * The `ManagedInstance` type for this API operation is only for on-premises managed nodes. Specify the name of the managed node in the following format: mi-ID_number. For example, mi-1a2b3c4d5e6f.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The type of resource from which you want to remove a tag.
         *
         * The `ManagedInstance` type for this API operation is only for on-premises managed nodes. Specify the name of the managed node in the following format: `mi-<i>ID_number</i> `. For example, `mi-1a2b3c4d5e6f`.
         */
        public var resourceType: aws.sdk.kotlin.services.ssm.model.ResourceTypeForTagging? = null
        /**
         * Tag keys that you want to remove from the specified resource.
         */
        public var tagKeys: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.RemoveTagsFromResourceRequest) : this() {
            this.resourceId = x.resourceId
            this.resourceType = x.resourceType
            this.tagKeys = x.tagKeys
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.RemoveTagsFromResourceRequest = RemoveTagsFromResourceRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
