// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

public class PutParameterRequest private constructor(builder: Builder) {
    /**
     * A regular expression used to validate the parameter value. For example, for String types with values restricted to numbers, you can specify the following: AllowedPattern=^\d+$
     */
    public val allowedPattern: kotlin.String? = builder.allowedPattern
    /**
     * The data type for a `String` parameter. Supported data types include plain text and Amazon Machine Image (AMI) IDs.
     *
     * **The following data type values are supported.**
     * + `text`
     * + `aws:ec2:image`
     * + `aws:ssm:integration`
     *
     * When you create a `String` parameter and specify `aws:ec2:image`, Amazon Web Services Systems Manager validates the parameter value is in the required format, such as `ami-12345abcdeEXAMPLE`, and that the specified AMI is available in your Amazon Web Services account.
     *
     * If the action is successful, the service sends back an HTTP 200 response which indicates a successful `PutParameter` call for all cases except for data type `aws:ec2:image`. If you call `PutParameter` with `aws:ec2:image` data type, a successful HTTP 200 response does not guarantee that your parameter was successfully created or updated. The `aws:ec2:image` value is validated asynchronously, and the `PutParameter` call returns before the validation is complete. If you submit an invalid AMI value, the PutParameter operation will return success, but the asynchronous validation will fail and the parameter will not be created or updated. To monitor whether your `aws:ec2:image` parameters are created successfully, see [Setting up notifications or trigger actions based on Parameter Store events](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-cwe.html). For more information about AMI format validation , see [Native parameter support for Amazon Machine Image IDs](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html).
     */
    public val dataType: kotlin.String? = builder.dataType
    /**
     * Information about the parameter that you want to add to the system. Optional but recommended.
     *
     * Don't enter personally identifiable information in this field.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The Key Management Service (KMS) ID that you want to use to encrypt a parameter. Use a custom key for better security. Required for parameters that use the `SecureString` data type.
     *
     * If you don't specify a key ID, the system uses the default key associated with your Amazon Web Services account, which is not as secure as using a custom key.
     * + To use a custom KMS key, choose the `SecureString` data type with the `Key ID` parameter.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * The fully qualified name of the parameter that you want to create or update.
     *
     * You can't enter the Amazon Resource Name (ARN) for a parameter, only the parameter name itself.
     *
     * The fully qualified name includes the complete hierarchy of the parameter path and name. For parameters in a hierarchy, you must include a leading forward slash character (/) when you create or reference a parameter. For example: `/Dev/DBServer/MySQL/db-string13`
     *
     * Naming Constraints:
     * + Parameter names are case sensitive.
     * + A parameter name must be unique within an Amazon Web Services Region
     * + A parameter name can't be prefixed with "`aws`" or "`ssm`" (case-insensitive).
     * + Parameter names can include only the following symbols and letters: `a-zA-Z0-9_.-`In addition, the slash character ( / ) is used to delineate hierarchies in parameter names. For example: `/Dev/Production/East/Project-ABC/MyParameter`
     * + Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
     * + Parameter hierarchies are limited to a maximum depth of fifteen levels.
     *
     * For additional information about valid values for parameter names, see [Creating Systems Manager parameters](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * The reported maximum length of 2048 characters for a parameter name includes 1037 characters that are reserved for internal use by Systems Manager. The maximum length for a parameter name that you specify is 1011 characters.
     *
     * This count of 1011 characters includes the characters in the ARN that precede the name you specify. This ARN length will vary depending on your partition and Region. For example, the following 45 characters count toward the 1011 character maximum for a parameter created in the US East (Ohio) Region: `arn:aws:ssm:us-east-2:111122223333:parameter/`.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Overwrite an existing parameter. The default value is `false`.
     */
    public val overwrite: kotlin.Boolean? = builder.overwrite
    /**
     * One or more policies to apply to a parameter. This operation takes a JSON array. Parameter Store, a tool in Amazon Web Services Systems Manager supports the following policy types:
     *
     * Expiration: This policy deletes the parameter after it expires. When you create the policy, you specify the expiration date. You can update the expiration date and time by updating the policy. Updating the *parameter* doesn't affect the expiration date and time. When the expiration time is reached, Parameter Store deletes the parameter.
     *
     * ExpirationNotification: This policy initiates an event in Amazon CloudWatch Events that notifies you about the expiration. By using this policy, you can receive notification before or after the expiration time is reached, in units of days or hours.
     *
     * NoChangeNotification: This policy initiates a CloudWatch Events event if a parameter hasn't been modified for a specified period of time. This policy type is useful when, for example, a secret needs to be changed within a period of time, but it hasn't been changed.
     *
     * All existing policies are preserved until you send new policies or an empty policy. For more information about parameter policies, see [Assigning parameter policies](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html).
     */
    public val policies: kotlin.String? = builder.policies
    /**
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a Systems Manager parameter to identify the type of resource to which it applies, the environment, or the type of configuration data referenced by the parameter. In this case, you could specify the following key-value pairs:
     * + `Key=Resource,Value=S3bucket`
     * + `Key=OS,Value=Windows`
     * + `Key=ParameterType,Value=LicenseKey`
     *
     * To add tags to an existing Systems Manager parameter, use the AddTagsToResource operation.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The parameter tier to assign to a parameter.
     *
     * Parameter Store offers a standard tier and an advanced tier for parameters. Standard parameters have a content size limit of 4 KB and can't be configured to use parameter policies. You can create a maximum of 10,000 standard parameters for each Region in an Amazon Web Services account. Standard parameters are offered at no additional cost.
     *
     * Advanced parameters have a content size limit of 8 KB and can be configured to use parameter policies. You can create a maximum of 100,000 advanced parameters for each Region in an Amazon Web Services account. Advanced parameters incur a charge. For more information, see [Managing parameter tiers](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html) in the *Amazon Web Services Systems Manager User Guide*.
     *
     * You can change a standard parameter to an advanced parameter any time. But you can't revert an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard parameter would result in data loss because the system would truncate the size of the parameter from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly, advanced parameters use a different form of encryption than standard parameters.
     *
     * If you no longer need an advanced parameter, or if you no longer want to incur charges for an advanced parameter, you must delete it and recreate it as a new standard parameter.
     *
     * **Using the Default Tier Configuration**
     *
     * In `PutParameter` requests, you can specify the tier to create the parameter in. Whenever you specify a tier in the request, Parameter Store creates or updates the parameter according to that request. However, if you don't specify a tier in a request, Parameter Store assigns the tier based on the current Parameter Store default tier configuration.
     *
     * The default tier when you begin using Parameter Store is the standard-parameter tier. If you use the advanced-parameter tier, you can specify one of the following as the default:
     * + **Advanced**: With this option, Parameter Store evaluates all requests as advanced parameters.
     * + **Intelligent-Tiering**: With this option, Parameter Store evaluates each request to determine if the parameter is standard or advanced. If the request doesn't include any options that require an advanced parameter, the parameter is created in the standard-parameter tier. If one or more options requiring an advanced parameter are included in the request, Parameter Store create a parameter in the advanced-parameter tier.This approach helps control your parameter-related costs by always creating standard parameters unless an advanced parameter is necessary.
     *
     * Options that require an advanced parameter include the following:
     * + The content size of the parameter is more than 4 KB.
     * + The parameter uses a parameter policy.
     * + More than 10,000 parameters already exist in your Amazon Web Services account in the current Amazon Web Services Region.
     *
     * For more information about configuring the default tier option, see [Specifying a default parameter tier](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html#ps-default-tier) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val tier: aws.sdk.kotlin.services.ssm.model.ParameterTier? = builder.tier
    /**
     * The type of parameter that you want to create.
     *
     * `SecureString` isn't currently supported for CloudFormation templates.
     *
     * Items in a `StringList` must be separated by a comma (,). You can't use other punctuation or special character to escape items in the list. If you have a parameter value that requires a comma, then use the `String` data type.
     *
     * Specifying a parameter type isn't required when updating a parameter. You must specify a parameter type when creating a parameter.
     */
    public val type: aws.sdk.kotlin.services.ssm.model.ParameterType? = builder.type
    /**
     * The parameter value that you want to add to the system. Standard parameters have a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.
     *
     * Parameters can't be referenced or nested in the values of other parameters. You can't include values wrapped in double brackets `{{}}` or `{{ssm:<i>parameter-name</i>}}` in a parameter value.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PutParameterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutParameterRequest(")
        append("allowedPattern=$allowedPattern,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("keyId=$keyId,")
        append("name=$name,")
        append("overwrite=$overwrite,")
        append("policies=$policies,")
        append("tags=$tags,")
        append("tier=$tier,")
        append("type=$type,")
        append("value=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowedPattern?.hashCode() ?: 0
        result = 31 * result + (this.dataType?.hashCode() ?: 0)
        result = 31 * result + (this.description?.hashCode() ?: 0)
        result = 31 * result + (this.keyId?.hashCode() ?: 0)
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.overwrite?.hashCode() ?: 0)
        result = 31 * result + (this.policies?.hashCode() ?: 0)
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        result = 31 * result + (this.tier?.hashCode() ?: 0)
        result = 31 * result + (this.type?.hashCode() ?: 0)
        result = 31 * result + (this.value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutParameterRequest

        if (allowedPattern != other.allowedPattern) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (keyId != other.keyId) return false
        if (name != other.name) return false
        if (overwrite != other.overwrite) return false
        if (policies != other.policies) return false
        if (tags != other.tags) return false
        if (tier != other.tier) return false
        if (type != other.type) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PutParameterRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A regular expression used to validate the parameter value. For example, for String types with values restricted to numbers, you can specify the following: AllowedPattern=^\d+$
         */
        public var allowedPattern: kotlin.String? = null
        /**
         * The data type for a `String` parameter. Supported data types include plain text and Amazon Machine Image (AMI) IDs.
         *
         * **The following data type values are supported.**
         * + `text`
         * + `aws:ec2:image`
         * + `aws:ssm:integration`
         *
         * When you create a `String` parameter and specify `aws:ec2:image`, Amazon Web Services Systems Manager validates the parameter value is in the required format, such as `ami-12345abcdeEXAMPLE`, and that the specified AMI is available in your Amazon Web Services account.
         *
         * If the action is successful, the service sends back an HTTP 200 response which indicates a successful `PutParameter` call for all cases except for data type `aws:ec2:image`. If you call `PutParameter` with `aws:ec2:image` data type, a successful HTTP 200 response does not guarantee that your parameter was successfully created or updated. The `aws:ec2:image` value is validated asynchronously, and the `PutParameter` call returns before the validation is complete. If you submit an invalid AMI value, the PutParameter operation will return success, but the asynchronous validation will fail and the parameter will not be created or updated. To monitor whether your `aws:ec2:image` parameters are created successfully, see [Setting up notifications or trigger actions based on Parameter Store events](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-cwe.html). For more information about AMI format validation , see [Native parameter support for Amazon Machine Image IDs](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-ec2-aliases.html).
         */
        public var dataType: kotlin.String? = null
        /**
         * Information about the parameter that you want to add to the system. Optional but recommended.
         *
         * Don't enter personally identifiable information in this field.
         */
        public var description: kotlin.String? = null
        /**
         * The Key Management Service (KMS) ID that you want to use to encrypt a parameter. Use a custom key for better security. Required for parameters that use the `SecureString` data type.
         *
         * If you don't specify a key ID, the system uses the default key associated with your Amazon Web Services account, which is not as secure as using a custom key.
         * + To use a custom KMS key, choose the `SecureString` data type with the `Key ID` parameter.
         */
        public var keyId: kotlin.String? = null
        /**
         * The fully qualified name of the parameter that you want to create or update.
         *
         * You can't enter the Amazon Resource Name (ARN) for a parameter, only the parameter name itself.
         *
         * The fully qualified name includes the complete hierarchy of the parameter path and name. For parameters in a hierarchy, you must include a leading forward slash character (/) when you create or reference a parameter. For example: `/Dev/DBServer/MySQL/db-string13`
         *
         * Naming Constraints:
         * + Parameter names are case sensitive.
         * + A parameter name must be unique within an Amazon Web Services Region
         * + A parameter name can't be prefixed with "`aws`" or "`ssm`" (case-insensitive).
         * + Parameter names can include only the following symbols and letters: `a-zA-Z0-9_.-`In addition, the slash character ( / ) is used to delineate hierarchies in parameter names. For example: `/Dev/Production/East/Project-ABC/MyParameter`
         * + Parameter names can't contain spaces. The service removes any spaces specified for the beginning or end of a parameter name. If the specified name for a parameter contains spaces between characters, the request fails with a `ValidationException` error.
         * + Parameter hierarchies are limited to a maximum depth of fifteen levels.
         *
         * For additional information about valid values for parameter names, see [Creating Systems Manager parameters](https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-create.html) in the *Amazon Web Services Systems Manager User Guide*.
         *
         * The reported maximum length of 2048 characters for a parameter name includes 1037 characters that are reserved for internal use by Systems Manager. The maximum length for a parameter name that you specify is 1011 characters.
         *
         * This count of 1011 characters includes the characters in the ARN that precede the name you specify. This ARN length will vary depending on your partition and Region. For example, the following 45 characters count toward the 1011 character maximum for a parameter created in the US East (Ohio) Region: `arn:aws:ssm:us-east-2:111122223333:parameter/`.
         */
        public var name: kotlin.String? = null
        /**
         * Overwrite an existing parameter. The default value is `false`.
         */
        public var overwrite: kotlin.Boolean? = null
        /**
         * One or more policies to apply to a parameter. This operation takes a JSON array. Parameter Store, a tool in Amazon Web Services Systems Manager supports the following policy types:
         *
         * Expiration: This policy deletes the parameter after it expires. When you create the policy, you specify the expiration date. You can update the expiration date and time by updating the policy. Updating the *parameter* doesn't affect the expiration date and time. When the expiration time is reached, Parameter Store deletes the parameter.
         *
         * ExpirationNotification: This policy initiates an event in Amazon CloudWatch Events that notifies you about the expiration. By using this policy, you can receive notification before or after the expiration time is reached, in units of days or hours.
         *
         * NoChangeNotification: This policy initiates a CloudWatch Events event if a parameter hasn't been modified for a specified period of time. This policy type is useful when, for example, a secret needs to be changed within a period of time, but it hasn't been changed.
         *
         * All existing policies are preserved until you send new policies or an empty policy. For more information about parameter policies, see [Assigning parameter policies](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-policies.html).
         */
        public var policies: kotlin.String? = null
        /**
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example, you might want to tag a Systems Manager parameter to identify the type of resource to which it applies, the environment, or the type of configuration data referenced by the parameter. In this case, you could specify the following key-value pairs:
         * + `Key=Resource,Value=S3bucket`
         * + `Key=OS,Value=Windows`
         * + `Key=ParameterType,Value=LicenseKey`
         *
         * To add tags to an existing Systems Manager parameter, use the AddTagsToResource operation.
         */
        public var tags: List<Tag>? = null
        /**
         * The parameter tier to assign to a parameter.
         *
         * Parameter Store offers a standard tier and an advanced tier for parameters. Standard parameters have a content size limit of 4 KB and can't be configured to use parameter policies. You can create a maximum of 10,000 standard parameters for each Region in an Amazon Web Services account. Standard parameters are offered at no additional cost.
         *
         * Advanced parameters have a content size limit of 8 KB and can be configured to use parameter policies. You can create a maximum of 100,000 advanced parameters for each Region in an Amazon Web Services account. Advanced parameters incur a charge. For more information, see [Managing parameter tiers](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html) in the *Amazon Web Services Systems Manager User Guide*.
         *
         * You can change a standard parameter to an advanced parameter any time. But you can't revert an advanced parameter to a standard parameter. Reverting an advanced parameter to a standard parameter would result in data loss because the system would truncate the size of the parameter from 8 KB to 4 KB. Reverting would also remove any policies attached to the parameter. Lastly, advanced parameters use a different form of encryption than standard parameters.
         *
         * If you no longer need an advanced parameter, or if you no longer want to incur charges for an advanced parameter, you must delete it and recreate it as a new standard parameter.
         *
         * **Using the Default Tier Configuration**
         *
         * In `PutParameter` requests, you can specify the tier to create the parameter in. Whenever you specify a tier in the request, Parameter Store creates or updates the parameter according to that request. However, if you don't specify a tier in a request, Parameter Store assigns the tier based on the current Parameter Store default tier configuration.
         *
         * The default tier when you begin using Parameter Store is the standard-parameter tier. If you use the advanced-parameter tier, you can specify one of the following as the default:
         * + **Advanced**: With this option, Parameter Store evaluates all requests as advanced parameters.
         * + **Intelligent-Tiering**: With this option, Parameter Store evaluates each request to determine if the parameter is standard or advanced. If the request doesn't include any options that require an advanced parameter, the parameter is created in the standard-parameter tier. If one or more options requiring an advanced parameter are included in the request, Parameter Store create a parameter in the advanced-parameter tier.This approach helps control your parameter-related costs by always creating standard parameters unless an advanced parameter is necessary.
         *
         * Options that require an advanced parameter include the following:
         * + The content size of the parameter is more than 4 KB.
         * + The parameter uses a parameter policy.
         * + More than 10,000 parameters already exist in your Amazon Web Services account in the current Amazon Web Services Region.
         *
         * For more information about configuring the default tier option, see [Specifying a default parameter tier](https://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html#ps-default-tier) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var tier: aws.sdk.kotlin.services.ssm.model.ParameterTier? = null
        /**
         * The type of parameter that you want to create.
         *
         * `SecureString` isn't currently supported for CloudFormation templates.
         *
         * Items in a `StringList` must be separated by a comma (,). You can't use other punctuation or special character to escape items in the list. If you have a parameter value that requires a comma, then use the `String` data type.
         *
         * Specifying a parameter type isn't required when updating a parameter. You must specify a parameter type when creating a parameter.
         */
        public var type: aws.sdk.kotlin.services.ssm.model.ParameterType? = null
        /**
         * The parameter value that you want to add to the system. Standard parameters have a value limit of 4 KB. Advanced parameters have a value limit of 8 KB.
         *
         * Parameters can't be referenced or nested in the values of other parameters. You can't include values wrapped in double brackets `{{}}` or `{{ssm:<i>parameter-name</i>}}` in a parameter value.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PutParameterRequest) : this() {
            this.allowedPattern = x.allowedPattern
            this.dataType = x.dataType
            this.description = x.description
            this.keyId = x.keyId
            this.name = x.name
            this.overwrite = x.overwrite
            this.policies = x.policies
            this.tags = x.tags
            this.tier = x.tier
            this.type = x.type
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PutParameterRequest = PutParameterRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
