// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the patches to use to update the managed nodes, including target operating systems and source repository. Applies to Linux managed nodes only.
 */
public class PatchSource private constructor(builder: Builder) {
    /**
     * The value of the repo configuration.
     *
     * **Example for yum repositories**
     *
     * `[main]`
     *
     * `name=MyCustomRepository`
     *
     * `baseurl=https://my-custom-repository`
     *
     * `enabled=1`
     *
     * For information about other options available for your yum repository configuration, see [dnf.conf(5)](https://man7.org/linux/man-pages/man5/dnf.conf.5.html) on the *man7.org* website.
     *
     * **Examples for Ubuntu Server and Debian Server**
     *
     * `deb http://security.ubuntu.com/ubuntu jammy main`
     *
     * `deb https://site.example.com/debian distribution component1 component2 component3`
     *
     * Repo information for Ubuntu Server repositories must be specifed in a single line. For more examples and information, see [jammy (5) sources.list.5.gz](https://manpages.ubuntu.com/manpages/jammy/man5/sources.list.5.html) on the *Ubuntu Server Manuals* website and [sources.list format](https://wiki.debian.org/SourcesList#sources.list_format) on the *Debian Wiki*.
     */
    public val configuration: kotlin.String = requireNotNull(builder.configuration) { "A non-null value must be provided for configuration" }
    /**
     * The name specified to identify the patch source.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see PatchFilter.
     */
    public val products: List<String> = requireNotNull(builder.products) { "A non-null value must be provided for products" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PatchSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchSource(")
        append("configuration=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("products=$products")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration.hashCode()
        result = 31 * result + (this.name.hashCode())
        result = 31 * result + (this.products.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchSource

        if (configuration != other.configuration) return false
        if (name != other.name) return false
        if (products != other.products) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PatchSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The value of the repo configuration.
         *
         * **Example for yum repositories**
         *
         * `[main]`
         *
         * `name=MyCustomRepository`
         *
         * `baseurl=https://my-custom-repository`
         *
         * `enabled=1`
         *
         * For information about other options available for your yum repository configuration, see [dnf.conf(5)](https://man7.org/linux/man-pages/man5/dnf.conf.5.html) on the *man7.org* website.
         *
         * **Examples for Ubuntu Server and Debian Server**
         *
         * `deb http://security.ubuntu.com/ubuntu jammy main`
         *
         * `deb https://site.example.com/debian distribution component1 component2 component3`
         *
         * Repo information for Ubuntu Server repositories must be specifed in a single line. For more examples and information, see [jammy (5) sources.list.5.gz](https://manpages.ubuntu.com/manpages/jammy/man5/sources.list.5.html) on the *Ubuntu Server Manuals* website and [sources.list format](https://wiki.debian.org/SourcesList#sources.list_format) on the *Debian Wiki*.
         */
        public var configuration: kotlin.String? = null
        /**
         * The name specified to identify the patch source.
         */
        public var name: kotlin.String? = null
        /**
         * The specific operating system versions a patch repository applies to, such as "Ubuntu16.04", "AmazonLinux2016.09", "RedhatEnterpriseLinux7.2" or "Suse12.7". For lists of supported product values, see PatchFilter.
         */
        public var products: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PatchSource) : this() {
            this.configuration = x.configuration
            this.name = x.name
            this.products = x.products
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PatchSource = PatchSource(this)

        internal fun correctErrors(): Builder {
            if (configuration == null) configuration = ""
            if (name == null) name = ""
            if (products == null) products = emptyList()
            return this
        }
    }
}
