// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines an approval rule for a patch baseline.
 */
public class PatchRule private constructor(builder: Builder) {
    /**
     * The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of `7` means that patches are approved seven days after they are released.
     *
     * This parameter is marked as `Required: No`, but your request must include a value for either `ApproveAfterDays` or `ApproveUntilDate`.
     *
     * Not supported for Debian Server or Ubuntu Server.
     *
     * Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the **Windows Server** tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val approveAfterDays: kotlin.Int? = builder.approveAfterDays
    /**
     * The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically.
     *
     * Enter dates in the format `YYYY-MM-DD`. For example, `2024-12-31`.
     *
     * This parameter is marked as `Required: No`, but your request must include a value for either `ApproveUntilDate` or `ApproveAfterDays`.
     *
     * Not supported for Debian Server or Ubuntu Server.
     *
     * Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the **Windows Server** tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val approveUntilDate: kotlin.String? = builder.approveUntilDate
    /**
     * A compliance severity level for all approved patches in a patch baseline.
     */
    public val complianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = builder.complianceLevel
    /**
     * For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is `false`. Applies to Linux managed nodes only.
     */
    public val enableNonSecurity: kotlin.Boolean? = builder.enableNonSecurity
    /**
     * The patch filter group that defines the criteria for the rule.
     */
    public val patchFilterGroup: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = builder.patchFilterGroup

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.PatchRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PatchRule(")
        append("approveAfterDays=$approveAfterDays,")
        append("approveUntilDate=$approveUntilDate,")
        append("complianceLevel=$complianceLevel,")
        append("enableNonSecurity=$enableNonSecurity,")
        append("patchFilterGroup=$patchFilterGroup")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = approveAfterDays ?: 0
        result = 31 * result + (this.approveUntilDate?.hashCode() ?: 0)
        result = 31 * result + (this.complianceLevel?.hashCode() ?: 0)
        result = 31 * result + (this.enableNonSecurity?.hashCode() ?: 0)
        result = 31 * result + (this.patchFilterGroup?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PatchRule

        if (approveAfterDays != other.approveAfterDays) return false
        if (approveUntilDate != other.approveUntilDate) return false
        if (complianceLevel != other.complianceLevel) return false
        if (enableNonSecurity != other.enableNonSecurity) return false
        if (patchFilterGroup != other.patchFilterGroup) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.PatchRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The number of days after the release date of each patch matched by the rule that the patch is marked as approved in the patch baseline. For example, a value of `7` means that patches are approved seven days after they are released.
         *
         * This parameter is marked as `Required: No`, but your request must include a value for either `ApproveAfterDays` or `ApproveUntilDate`.
         *
         * Not supported for Debian Server or Ubuntu Server.
         *
         * Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the **Windows Server** tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var approveAfterDays: kotlin.Int? = null
        /**
         * The cutoff date for auto approval of released patches. Any patches released on or before this date are installed automatically.
         *
         * Enter dates in the format `YYYY-MM-DD`. For example, `2024-12-31`.
         *
         * This parameter is marked as `Required: No`, but your request must include a value for either `ApproveUntilDate` or `ApproveAfterDays`.
         *
         * Not supported for Debian Server or Ubuntu Server.
         *
         * Use caution when setting this value for Windows Server patch baselines. Because patch updates that are replaced by later updates are removed, setting too broad a value for this parameter can result in crucial patches not being installed. For more information, see the **Windows Server** tab in the topic [How security patches are selected](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-selecting-patches.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var approveUntilDate: kotlin.String? = null
        /**
         * A compliance severity level for all approved patches in a patch baseline.
         */
        public var complianceLevel: aws.sdk.kotlin.services.ssm.model.PatchComplianceLevel? = null
        /**
         * For managed nodes identified by the approval rule filters, enables a patch baseline to apply non-security updates available in the specified repository. The default value is `false`. Applies to Linux managed nodes only.
         */
        public var enableNonSecurity: kotlin.Boolean? = null
        /**
         * The patch filter group that defines the criteria for the rule.
         */
        public var patchFilterGroup: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.PatchRule) : this() {
            this.approveAfterDays = x.approveAfterDays
            this.approveUntilDate = x.approveUntilDate
            this.complianceLevel = x.complianceLevel
            this.enableNonSecurity = x.enableNonSecurity
            this.patchFilterGroup = x.patchFilterGroup
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.PatchRule = PatchRule(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.PatchFilterGroup] inside the given [block]
         */
        public fun patchFilterGroup(block: aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.Builder.() -> kotlin.Unit) {
            this.patchFilterGroup = aws.sdk.kotlin.services.ssm.model.PatchFilterGroup.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
