// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A count of OpsItems.
 */
public class OpsItemSummary private constructor(builder: Builder) {
    /**
     * The time a runbook workflow ended. Currently reported only for the OpsItem type `/aws/changerequest`.
     */
    public val actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualEndTime
    /**
     * The time a runbook workflow started. Currently reported only for the OpsItem type `/aws/changerequest`.
     */
    public val actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualStartTime
    /**
     * A list of OpsItems by category.
     */
    public val category: kotlin.String? = builder.category
    /**
     * The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The date and time the OpsItem was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
     */
    public val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * The date and time the OpsItem was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * Operational data is custom data that provides useful reference details about the OpsItem.
     */
    public val operationalData: Map<String, OpsItemDataValue>? = builder.operationalData
    /**
     * The ID of the OpsItem.
     */
    public val opsItemId: kotlin.String? = builder.opsItemId
    /**
     * The type of OpsItem. Systems Manager supports the following types of OpsItems:
     * + `/aws/issue`This type of OpsItem is used for default OpsItems created by OpsCenter.
     * + `/aws/changerequest`This type of OpsItem is used by Change Manager for reviewing and approving or rejecting change requests.
     * + `/aws/insight`This type of OpsItem is used by OpsCenter for aggregating and reporting on duplicate OpsItems.
     */
    public val opsItemType: kotlin.String? = builder.opsItemType
    /**
     * The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type `/aws/changerequest`.
     */
    public val plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedEndTime
    /**
     * The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type `/aws/changerequest`.
     */
    public val plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedStartTime
    /**
     * The importance of this OpsItem in relation to other OpsItems in the system.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * A list of OpsItems by severity.
     */
    public val severity: kotlin.String? = builder.severity
    /**
     * The impacted Amazon Web Services resource.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The OpsItem status.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.OpsItemStatus? = builder.status
    /**
     * A short heading that describes the nature of the OpsItem and the impacted resource.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.OpsItemSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpsItemSummary(")
        append("actualEndTime=$actualEndTime,")
        append("actualStartTime=$actualStartTime,")
        append("category=$category,")
        append("createdBy=$createdBy,")
        append("createdTime=$createdTime,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("operationalData=$operationalData,")
        append("opsItemId=$opsItemId,")
        append("opsItemType=$opsItemType,")
        append("plannedEndTime=$plannedEndTime,")
        append("plannedStartTime=$plannedStartTime,")
        append("priority=$priority,")
        append("severity=$severity,")
        append("source=$source,")
        append("status=$status,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualEndTime?.hashCode() ?: 0
        result = 31 * result + (this.actualStartTime?.hashCode() ?: 0)
        result = 31 * result + (this.category?.hashCode() ?: 0)
        result = 31 * result + (this.createdBy?.hashCode() ?: 0)
        result = 31 * result + (this.createdTime?.hashCode() ?: 0)
        result = 31 * result + (this.lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (this.lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (this.operationalData?.hashCode() ?: 0)
        result = 31 * result + (this.opsItemId?.hashCode() ?: 0)
        result = 31 * result + (this.opsItemType?.hashCode() ?: 0)
        result = 31 * result + (this.plannedEndTime?.hashCode() ?: 0)
        result = 31 * result + (this.plannedStartTime?.hashCode() ?: 0)
        result = 31 * result + (this.priority ?: 0)
        result = 31 * result + (this.severity?.hashCode() ?: 0)
        result = 31 * result + (this.source?.hashCode() ?: 0)
        result = 31 * result + (this.status?.hashCode() ?: 0)
        result = 31 * result + (this.title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpsItemSummary

        if (actualEndTime != other.actualEndTime) return false
        if (actualStartTime != other.actualStartTime) return false
        if (category != other.category) return false
        if (createdBy != other.createdBy) return false
        if (createdTime != other.createdTime) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (operationalData != other.operationalData) return false
        if (opsItemId != other.opsItemId) return false
        if (opsItemType != other.opsItemType) return false
        if (plannedEndTime != other.plannedEndTime) return false
        if (plannedStartTime != other.plannedStartTime) return false
        if (priority != other.priority) return false
        if (severity != other.severity) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.OpsItemSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time a runbook workflow ended. Currently reported only for the OpsItem type `/aws/changerequest`.
         */
        public var actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time a runbook workflow started. Currently reported only for the OpsItem type `/aws/changerequest`.
         */
        public var actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of OpsItems by category.
         */
        public var category: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The date and time the OpsItem was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM entity that created the OpsItem.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The date and time the OpsItem was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Operational data is custom data that provides useful reference details about the OpsItem.
         */
        public var operationalData: Map<String, OpsItemDataValue>? = null
        /**
         * The ID of the OpsItem.
         */
        public var opsItemId: kotlin.String? = null
        /**
         * The type of OpsItem. Systems Manager supports the following types of OpsItems:
         * + `/aws/issue`This type of OpsItem is used for default OpsItems created by OpsCenter.
         * + `/aws/changerequest`This type of OpsItem is used by Change Manager for reviewing and approving or rejecting change requests.
         * + `/aws/insight`This type of OpsItem is used by OpsCenter for aggregating and reporting on duplicate OpsItems.
         */
        public var opsItemType: kotlin.String? = null
        /**
         * The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type `/aws/changerequest`.
         */
        public var plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type `/aws/changerequest`.
         */
        public var plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The importance of this OpsItem in relation to other OpsItems in the system.
         */
        public var priority: kotlin.Int? = null
        /**
         * A list of OpsItems by severity.
         */
        public var severity: kotlin.String? = null
        /**
         * The impacted Amazon Web Services resource.
         */
        public var source: kotlin.String? = null
        /**
         * The OpsItem status.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.OpsItemStatus? = null
        /**
         * A short heading that describes the nature of the OpsItem and the impacted resource.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.OpsItemSummary) : this() {
            this.actualEndTime = x.actualEndTime
            this.actualStartTime = x.actualStartTime
            this.category = x.category
            this.createdBy = x.createdBy
            this.createdTime = x.createdTime
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.operationalData = x.operationalData
            this.opsItemId = x.opsItemId
            this.opsItemType = x.opsItemType
            this.plannedEndTime = x.plannedEndTime
            this.plannedStartTime = x.plannedStartTime
            this.priority = x.priority
            this.severity = x.severity
            this.source = x.source
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.OpsItemSummary = OpsItemSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
