// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate, and remediate operational work items (OpsItems) impacting the performance and health of their Amazon Web Services resources. OpsCenter is integrated with Amazon EventBridge and Amazon CloudWatch. This means you can configure these services to automatically create an OpsItem in OpsCenter when a CloudWatch alarm enters the ALARM state or when EventBridge processes an event from any Amazon Web Services service that publishes events. Configuring Amazon CloudWatch alarms and EventBridge events to automatically create OpsItems allows you to quickly diagnose and remediate issues with Amazon Web Services resources from a single console.
 *
 * To help you diagnose issues, each OpsItem includes contextually relevant information such as the name and ID of the Amazon Web Services resource that generated the OpsItem, alarm or event details, alarm history, and an alarm timeline graph. For the Amazon Web Services resource, OpsCenter aggregates information from Config, CloudTrail logs, and EventBridge, so you don't have to navigate across multiple console pages during your investigation. For more information, see [Amazon Web Services Systems Manager OpsCenter](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html) in the *Amazon Web Services Systems Manager User Guide*.
 */
public class OpsItem private constructor(builder: Builder) {
    /**
     * The time a runbook workflow ended. Currently reported only for the OpsItem type `/aws/changerequest`.
     */
    public val actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualEndTime
    /**
     * The time a runbook workflow started. Currently reported only for the OpsItem type `/aws/changerequest`.
     */
    public val actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.actualStartTime
    /**
     * An OpsItem category. Category options include: Availability, Cost, Performance, Recovery, Security.
     */
    public val category: kotlin.String? = builder.category
    /**
     * The ARN of the Amazon Web Services account that created the OpsItem.
     */
    public val createdBy: kotlin.String? = builder.createdBy
    /**
     * The date and time the OpsItem was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The OpsItem description.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the Amazon Web Services account that last updated the OpsItem.
     */
    public val lastModifiedBy: kotlin.String? = builder.lastModifiedBy
    /**
     * The date and time the OpsItem was last updated.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where notifications are sent when this OpsItem is edited or changed.
     */
    public val notifications: List<OpsItemNotification>? = builder.notifications
    /**
     * Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.
     *
     * Operational data keys *can't* begin with the following: `amazon`, `aws`, `amzn`, `ssm`, `/amazon`, `/aws`, `/amzn`, `/ssm`.
     *
     * You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the DescribeOpsItems API operation) can view and search on the specified data. Operational data that isn't searchable is only viewable by users who have access to the OpsItem (as provided by the GetOpsItem API operation).
     *
     * Use the `/aws/resources` key in OperationalData to specify a related resource in the request. Use the `/aws/automations` key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see [Creating OpsItems manually](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-manually-create-OpsItems.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val operationalData: Map<String, OpsItemDataValue>? = builder.operationalData
    /**
     * The OpsItem Amazon Resource Name (ARN).
     */
    public val opsItemArn: kotlin.String? = builder.opsItemArn
    /**
     * The ID of the OpsItem.
     */
    public val opsItemId: kotlin.String? = builder.opsItemId
    /**
     * The type of OpsItem. Systems Manager supports the following types of OpsItems:
     * + `/aws/issue`This type of OpsItem is used for default OpsItems created by OpsCenter.
     * + `/aws/changerequest`This type of OpsItem is used by Change Manager for reviewing and approving or rejecting change requests.
     * + `/aws/insight`This type of OpsItem is used by OpsCenter for aggregating and reporting on duplicate OpsItems.
     */
    public val opsItemType: kotlin.String? = builder.opsItemType
    /**
     * The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type `/aws/changerequest`.
     */
    public val plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedEndTime
    /**
     * The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type `/aws/changerequest`.
     */
    public val plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.plannedStartTime
    /**
     * The importance of this OpsItem in relation to other OpsItems in the system.
     */
    public val priority: kotlin.Int? = builder.priority
    /**
     * One or more OpsItems that share something in common with the current OpsItem. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.
     */
    public val relatedOpsItems: List<RelatedOpsItem>? = builder.relatedOpsItems
    /**
     * The severity of the OpsItem. Severity options range from 1 to 4.
     */
    public val severity: kotlin.String? = builder.severity
    /**
     * The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of source.
     */
    public val source: kotlin.String? = builder.source
    /**
     * The OpsItem status. For more information, see [Editing OpsItem details](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html) in the *Amazon Web Services Systems Manager User Guide*.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.OpsItemStatus? = builder.status
    /**
     * A short heading that describes the nature of the OpsItem and the impacted resource.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The version of this OpsItem. Each time the OpsItem is edited the version number increments by one.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.OpsItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OpsItem(")
        append("actualEndTime=$actualEndTime,")
        append("actualStartTime=$actualStartTime,")
        append("category=$category,")
        append("createdBy=$createdBy,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("lastModifiedBy=$lastModifiedBy,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("notifications=$notifications,")
        append("operationalData=$operationalData,")
        append("opsItemArn=$opsItemArn,")
        append("opsItemId=$opsItemId,")
        append("opsItemType=$opsItemType,")
        append("plannedEndTime=$plannedEndTime,")
        append("plannedStartTime=$plannedStartTime,")
        append("priority=$priority,")
        append("relatedOpsItems=$relatedOpsItems,")
        append("severity=$severity,")
        append("source=$source,")
        append("status=$status,")
        append("title=$title,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualEndTime?.hashCode() ?: 0
        result = 31 * result + (this.actualStartTime?.hashCode() ?: 0)
        result = 31 * result + (this.category?.hashCode() ?: 0)
        result = 31 * result + (this.createdBy?.hashCode() ?: 0)
        result = 31 * result + (this.createdTime?.hashCode() ?: 0)
        result = 31 * result + (this.description?.hashCode() ?: 0)
        result = 31 * result + (this.lastModifiedBy?.hashCode() ?: 0)
        result = 31 * result + (this.lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (this.notifications?.hashCode() ?: 0)
        result = 31 * result + (this.operationalData?.hashCode() ?: 0)
        result = 31 * result + (this.opsItemArn?.hashCode() ?: 0)
        result = 31 * result + (this.opsItemId?.hashCode() ?: 0)
        result = 31 * result + (this.opsItemType?.hashCode() ?: 0)
        result = 31 * result + (this.plannedEndTime?.hashCode() ?: 0)
        result = 31 * result + (this.plannedStartTime?.hashCode() ?: 0)
        result = 31 * result + (this.priority ?: 0)
        result = 31 * result + (this.relatedOpsItems?.hashCode() ?: 0)
        result = 31 * result + (this.severity?.hashCode() ?: 0)
        result = 31 * result + (this.source?.hashCode() ?: 0)
        result = 31 * result + (this.status?.hashCode() ?: 0)
        result = 31 * result + (this.title?.hashCode() ?: 0)
        result = 31 * result + (this.version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OpsItem

        if (actualEndTime != other.actualEndTime) return false
        if (actualStartTime != other.actualStartTime) return false
        if (category != other.category) return false
        if (createdBy != other.createdBy) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (lastModifiedBy != other.lastModifiedBy) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (notifications != other.notifications) return false
        if (operationalData != other.operationalData) return false
        if (opsItemArn != other.opsItemArn) return false
        if (opsItemId != other.opsItemId) return false
        if (opsItemType != other.opsItemType) return false
        if (plannedEndTime != other.plannedEndTime) return false
        if (plannedStartTime != other.plannedStartTime) return false
        if (priority != other.priority) return false
        if (relatedOpsItems != other.relatedOpsItems) return false
        if (severity != other.severity) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (title != other.title) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.OpsItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time a runbook workflow ended. Currently reported only for the OpsItem type `/aws/changerequest`.
         */
        public var actualEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time a runbook workflow started. Currently reported only for the OpsItem type `/aws/changerequest`.
         */
        public var actualStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An OpsItem category. Category options include: Availability, Cost, Performance, Recovery, Security.
         */
        public var category: kotlin.String? = null
        /**
         * The ARN of the Amazon Web Services account that created the OpsItem.
         */
        public var createdBy: kotlin.String? = null
        /**
         * The date and time the OpsItem was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The OpsItem description.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the Amazon Web Services account that last updated the OpsItem.
         */
        public var lastModifiedBy: kotlin.String? = null
        /**
         * The date and time the OpsItem was last updated.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) of an Amazon Simple Notification Service (Amazon SNS) topic where notifications are sent when this OpsItem is edited or changed.
         */
        public var notifications: List<OpsItemNotification>? = null
        /**
         * Operational data is custom data that provides useful reference details about the OpsItem. For example, you can specify log files, error strings, license keys, troubleshooting tips, or other relevant data. You enter operational data as key-value pairs. The key has a maximum length of 128 characters. The value has a maximum size of 20 KB.
         *
         * Operational data keys *can't* begin with the following: `amazon`, `aws`, `amzn`, `ssm`, `/amazon`, `/aws`, `/amzn`, `/ssm`.
         *
         * You can choose to make the data searchable by other users in the account or you can restrict search access. Searchable data means that all users with access to the OpsItem Overview page (as provided by the DescribeOpsItems API operation) can view and search on the specified data. Operational data that isn't searchable is only viewable by users who have access to the OpsItem (as provided by the GetOpsItem API operation).
         *
         * Use the `/aws/resources` key in OperationalData to specify a related resource in the request. Use the `/aws/automations` key in OperationalData to associate an Automation runbook with the OpsItem. To view Amazon Web Services CLI example commands that use these keys, see [Creating OpsItems manually](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-manually-create-OpsItems.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var operationalData: Map<String, OpsItemDataValue>? = null
        /**
         * The OpsItem Amazon Resource Name (ARN).
         */
        public var opsItemArn: kotlin.String? = null
        /**
         * The ID of the OpsItem.
         */
        public var opsItemId: kotlin.String? = null
        /**
         * The type of OpsItem. Systems Manager supports the following types of OpsItems:
         * + `/aws/issue`This type of OpsItem is used for default OpsItems created by OpsCenter.
         * + `/aws/changerequest`This type of OpsItem is used by Change Manager for reviewing and approving or rejecting change requests.
         * + `/aws/insight`This type of OpsItem is used by OpsCenter for aggregating and reporting on duplicate OpsItems.
         */
        public var opsItemType: kotlin.String? = null
        /**
         * The time specified in a change request for a runbook workflow to end. Currently supported only for the OpsItem type `/aws/changerequest`.
         */
        public var plannedEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time specified in a change request for a runbook workflow to start. Currently supported only for the OpsItem type `/aws/changerequest`.
         */
        public var plannedStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The importance of this OpsItem in relation to other OpsItems in the system.
         */
        public var priority: kotlin.Int? = null
        /**
         * One or more OpsItems that share something in common with the current OpsItem. For example, related OpsItems can include OpsItems with similar error messages, impacted resources, or statuses for the impacted resource.
         */
        public var relatedOpsItems: List<RelatedOpsItem>? = null
        /**
         * The severity of the OpsItem. Severity options range from 1 to 4.
         */
        public var severity: kotlin.String? = null
        /**
         * The origin of the OpsItem, such as Amazon EC2 or Systems Manager. The impacted resource is a subset of source.
         */
        public var source: kotlin.String? = null
        /**
         * The OpsItem status. For more information, see [Editing OpsItem details](https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html) in the *Amazon Web Services Systems Manager User Guide*.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.OpsItemStatus? = null
        /**
         * A short heading that describes the nature of the OpsItem and the impacted resource.
         */
        public var title: kotlin.String? = null
        /**
         * The version of this OpsItem. Each time the OpsItem is edited the version number increments by one.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.OpsItem) : this() {
            this.actualEndTime = x.actualEndTime
            this.actualStartTime = x.actualStartTime
            this.category = x.category
            this.createdBy = x.createdBy
            this.createdTime = x.createdTime
            this.description = x.description
            this.lastModifiedBy = x.lastModifiedBy
            this.lastModifiedTime = x.lastModifiedTime
            this.notifications = x.notifications
            this.operationalData = x.operationalData
            this.opsItemArn = x.opsItemArn
            this.opsItemId = x.opsItemId
            this.opsItemType = x.opsItemType
            this.plannedEndTime = x.plannedEndTime
            this.plannedStartTime = x.plannedStartTime
            this.priority = x.priority
            this.relatedOpsItems = x.relatedOpsItems
            this.severity = x.severity
            this.source = x.source
            this.status = x.status
            this.title = x.title
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.OpsItem = OpsItem(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
