// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about ownership of a managed node.
 */
public class NodeOwnerInfo private constructor(builder: Builder) {
    /**
     * The ID of the Amazon Web Services account that owns the managed node.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The ID of the organization unit (OU) that the account is part of.
     */
    public val organizationalUnitId: kotlin.String? = builder.organizationalUnitId
    /**
     * The path for the organizational unit (OU) that owns the managed node. The path for the OU is built using the IDs of the organization, root, and all OUs in the path down to and including the OU. For example:
     *
     * `o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-ghi0-awsccccc/ou-jkl0-awsddddd/`
     */
    public val organizationalUnitPath: kotlin.String? = builder.organizationalUnitPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.NodeOwnerInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("NodeOwnerInfo(")
        append("accountId=$accountId,")
        append("organizationalUnitId=$organizationalUnitId,")
        append("organizationalUnitPath=$organizationalUnitPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (this.organizationalUnitId?.hashCode() ?: 0)
        result = 31 * result + (this.organizationalUnitPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as NodeOwnerInfo

        if (accountId != other.accountId) return false
        if (organizationalUnitId != other.organizationalUnitId) return false
        if (organizationalUnitPath != other.organizationalUnitPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.NodeOwnerInfo = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the Amazon Web Services account that owns the managed node.
         */
        public var accountId: kotlin.String? = null
        /**
         * The ID of the organization unit (OU) that the account is part of.
         */
        public var organizationalUnitId: kotlin.String? = null
        /**
         * The path for the organizational unit (OU) that owns the managed node. The path for the OU is built using the IDs of the organization, root, and all OUs in the path down to and including the OU. For example:
         *
         * `o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-ghi0-awsccccc/ou-jkl0-awsddddd/`
         */
        public var organizationalUnitPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.NodeOwnerInfo) : this() {
            this.accountId = x.accountId
            this.organizationalUnitId = x.organizationalUnitId
            this.organizationalUnitPath = x.organizationalUnitPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.NodeOwnerInfo = NodeOwnerInfo(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
