// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The target registered with the maintenance window.
 */
public class MaintenanceWindowTarget private constructor(builder: Builder) {
    /**
     * A description for the target.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name for the maintenance window target.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A user-provided value that will be included in any Amazon CloudWatch Events events that are raised while running tasks for these targets in this maintenance window.
     */
    public val ownerInformation: kotlin.String? = builder.ownerInformation
    /**
     * The type of target that is being registered with the maintenance window.
     */
    public val resourceType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowResourceType? = builder.resourceType
    /**
     * The targets, either managed nodes or tags.
     *
     * Specify managed nodes using the following format:
     *
     * `Key=instanceids,Values=<instanceid1>,<instanceid2>`
     *
     * Tags are specified using the following format:
     *
     * `Key=<tag name>,Values=<tag value>`.
     */
    public val targets: List<Target>? = builder.targets
    /**
     * The ID of the maintenance window to register the target with.
     */
    public val windowId: kotlin.String? = builder.windowId
    /**
     * The ID of the target.
     */
    public val windowTargetId: kotlin.String? = builder.windowTargetId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTarget = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceWindowTarget(")
        append("description=*** Sensitive Data Redacted ***,")
        append("name=$name,")
        append("ownerInformation=*** Sensitive Data Redacted ***,")
        append("resourceType=$resourceType,")
        append("targets=$targets,")
        append("windowId=$windowId,")
        append("windowTargetId=$windowTargetId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (this.name?.hashCode() ?: 0)
        result = 31 * result + (this.ownerInformation?.hashCode() ?: 0)
        result = 31 * result + (this.resourceType?.hashCode() ?: 0)
        result = 31 * result + (this.targets?.hashCode() ?: 0)
        result = 31 * result + (this.windowId?.hashCode() ?: 0)
        result = 31 * result + (this.windowTargetId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceWindowTarget

        if (description != other.description) return false
        if (name != other.name) return false
        if (ownerInformation != other.ownerInformation) return false
        if (resourceType != other.resourceType) return false
        if (targets != other.targets) return false
        if (windowId != other.windowId) return false
        if (windowTargetId != other.windowTargetId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTarget = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description for the target.
         */
        public var description: kotlin.String? = null
        /**
         * The name for the maintenance window target.
         */
        public var name: kotlin.String? = null
        /**
         * A user-provided value that will be included in any Amazon CloudWatch Events events that are raised while running tasks for these targets in this maintenance window.
         */
        public var ownerInformation: kotlin.String? = null
        /**
         * The type of target that is being registered with the maintenance window.
         */
        public var resourceType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowResourceType? = null
        /**
         * The targets, either managed nodes or tags.
         *
         * Specify managed nodes using the following format:
         *
         * `Key=instanceids,Values=<instanceid1>,<instanceid2>`
         *
         * Tags are specified using the following format:
         *
         * `Key=<tag name>,Values=<tag value>`.
         */
        public var targets: List<Target>? = null
        /**
         * The ID of the maintenance window to register the target with.
         */
        public var windowId: kotlin.String? = null
        /**
         * The ID of the target.
         */
        public var windowTargetId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTarget) : this() {
            this.description = x.description
            this.name = x.name
            this.ownerInformation = x.ownerInformation
            this.resourceType = x.resourceType
            this.targets = x.targets
            this.windowId = x.windowId
            this.windowTargetId = x.windowTargetId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTarget = MaintenanceWindowTarget(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
