// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a task execution performed as part of a maintenance window execution.
 */
public class MaintenanceWindowExecutionTaskIdentity private constructor(builder: Builder) {
    /**
     * The details for the CloudWatch alarm applied to your maintenance window task.
     */
    public val alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = builder.alarmConfiguration
    /**
     * The time the task execution finished.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The time the task execution started.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the task execution.
     */
    public val status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = builder.status
    /**
     * The details explaining the status of the task execution. Not available for all status values.
     */
    public val statusDetails: kotlin.String? = builder.statusDetails
    /**
     * The Amazon Resource Name (ARN) of the task that ran.
     */
    public val taskArn: kotlin.String? = builder.taskArn
    /**
     * The ID of the specific task execution in the maintenance window execution.
     */
    public val taskExecutionId: kotlin.String? = builder.taskExecutionId
    /**
     * The type of task that ran.
     */
    public val taskType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = builder.taskType
    /**
     * The CloudWatch alarm that was invoked by the maintenance window task.
     */
    public val triggeredAlarms: List<AlarmStateInformation>? = builder.triggeredAlarms
    /**
     * The ID of the maintenance window execution that ran the task.
     */
    public val windowExecutionId: kotlin.String? = builder.windowExecutionId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskIdentity = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MaintenanceWindowExecutionTaskIdentity(")
        append("alarmConfiguration=$alarmConfiguration,")
        append("endTime=$endTime,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusDetails=$statusDetails,")
        append("taskArn=$taskArn,")
        append("taskExecutionId=$taskExecutionId,")
        append("taskType=$taskType,")
        append("triggeredAlarms=$triggeredAlarms,")
        append("windowExecutionId=$windowExecutionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = alarmConfiguration?.hashCode() ?: 0
        result = 31 * result + (this.endTime?.hashCode() ?: 0)
        result = 31 * result + (this.startTime?.hashCode() ?: 0)
        result = 31 * result + (this.status?.hashCode() ?: 0)
        result = 31 * result + (this.statusDetails?.hashCode() ?: 0)
        result = 31 * result + (this.taskArn?.hashCode() ?: 0)
        result = 31 * result + (this.taskExecutionId?.hashCode() ?: 0)
        result = 31 * result + (this.taskType?.hashCode() ?: 0)
        result = 31 * result + (this.triggeredAlarms?.hashCode() ?: 0)
        result = 31 * result + (this.windowExecutionId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MaintenanceWindowExecutionTaskIdentity

        if (alarmConfiguration != other.alarmConfiguration) return false
        if (endTime != other.endTime) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusDetails != other.statusDetails) return false
        if (taskArn != other.taskArn) return false
        if (taskExecutionId != other.taskExecutionId) return false
        if (taskType != other.taskType) return false
        if (triggeredAlarms != other.triggeredAlarms) return false
        if (windowExecutionId != other.windowExecutionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskIdentity = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The details for the CloudWatch alarm applied to your maintenance window task.
         */
        public var alarmConfiguration: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration? = null
        /**
         * The time the task execution finished.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time the task execution started.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the task execution.
         */
        public var status: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionStatus? = null
        /**
         * The details explaining the status of the task execution. Not available for all status values.
         */
        public var statusDetails: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the task that ran.
         */
        public var taskArn: kotlin.String? = null
        /**
         * The ID of the specific task execution in the maintenance window execution.
         */
        public var taskExecutionId: kotlin.String? = null
        /**
         * The type of task that ran.
         */
        public var taskType: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowTaskType? = null
        /**
         * The CloudWatch alarm that was invoked by the maintenance window task.
         */
        public var triggeredAlarms: List<AlarmStateInformation>? = null
        /**
         * The ID of the maintenance window execution that ran the task.
         */
        public var windowExecutionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskIdentity) : this() {
            this.alarmConfiguration = x.alarmConfiguration
            this.endTime = x.endTime
            this.startTime = x.startTime
            this.status = x.status
            this.statusDetails = x.statusDetails
            this.taskArn = x.taskArn
            this.taskExecutionId = x.taskExecutionId
            this.taskType = x.taskType
            this.triggeredAlarms = x.triggeredAlarms
            this.windowExecutionId = x.windowExecutionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.MaintenanceWindowExecutionTaskIdentity = MaintenanceWindowExecutionTaskIdentity(this)

        /**
         * construct an [aws.sdk.kotlin.services.ssm.model.AlarmConfiguration] inside the given [block]
         */
        public fun alarmConfiguration(block: aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.Builder.() -> kotlin.Unit) {
            this.alarmConfiguration = aws.sdk.kotlin.services.ssm.model.AlarmConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
