// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The inventory result item.
 */
public class InventoryResultItem private constructor(builder: Builder) {
    /**
     * The time inventory item data was captured.
     */
    public val captureTime: kotlin.String? = builder.captureTime
    /**
     * Contains all the inventory data of the item type. Results include attribute names and values.
     */
    public val content: List<Map<String, String>> = requireNotNull(builder.content) { "A non-null value must be provided for content" }
    /**
     * MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API doesn't update the inventory item type contents if the MD5 hash hasn't changed since last update.
     */
    public val contentHash: kotlin.String? = builder.contentHash
    /**
     * The schema version for the inventory result item/
     */
    public val schemaVersion: kotlin.String = requireNotNull(builder.schemaVersion) { "A non-null value must be provided for schemaVersion" }
    /**
     * The name of the inventory result item type.
     */
    public val typeName: kotlin.String = requireNotNull(builder.typeName) { "A non-null value must be provided for typeName" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.InventoryResultItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("InventoryResultItem(")
        append("captureTime=$captureTime,")
        append("content=$content,")
        append("contentHash=$contentHash,")
        append("schemaVersion=$schemaVersion,")
        append("typeName=$typeName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = captureTime?.hashCode() ?: 0
        result = 31 * result + (this.content.hashCode())
        result = 31 * result + (this.contentHash?.hashCode() ?: 0)
        result = 31 * result + (this.schemaVersion.hashCode())
        result = 31 * result + (this.typeName.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as InventoryResultItem

        if (captureTime != other.captureTime) return false
        if (content != other.content) return false
        if (contentHash != other.contentHash) return false
        if (schemaVersion != other.schemaVersion) return false
        if (typeName != other.typeName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.InventoryResultItem = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The time inventory item data was captured.
         */
        public var captureTime: kotlin.String? = null
        /**
         * Contains all the inventory data of the item type. Results include attribute names and values.
         */
        public var content: List<Map<String, String>>? = null
        /**
         * MD5 hash of the inventory item type contents. The content hash is used to determine whether to update inventory information. The PutInventory API doesn't update the inventory item type contents if the MD5 hash hasn't changed since last update.
         */
        public var contentHash: kotlin.String? = null
        /**
         * The schema version for the inventory result item/
         */
        public var schemaVersion: kotlin.String? = null
        /**
         * The name of the inventory result item type.
         */
        public var typeName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.InventoryResultItem) : this() {
            this.captureTime = x.captureTime
            this.content = x.content
            this.contentHash = x.contentHash
            this.schemaVersion = x.schemaVersion
            this.typeName = x.typeName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.InventoryResultItem = InventoryResultItem(this)

        internal fun correctErrors(): Builder {
            if (content == null) content = emptyList()
            if (schemaVersion == null) schemaVersion = ""
            if (typeName == null) typeName = ""
            return this
        }
    }
}
