// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.ssm.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a reviewer's response to a document review request.
 */
public class DocumentReviewerResponseSource private constructor(builder: Builder) {
    /**
     * The comment entered by a reviewer as part of their document review response.
     */
    public val comment: List<DocumentReviewCommentSource>? = builder.comment
    /**
     * The date and time that a reviewer entered a response to a document review request.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The current review status of a new custom SSM document created by a member of your organization, or of the latest version of an existing SSM document.
     *
     * Only one version of a document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.
     *
     * Only one version of a document can be in review, or PENDING, at a time.
     */
    public val reviewStatus: aws.sdk.kotlin.services.ssm.model.ReviewStatus? = builder.reviewStatus
    /**
     * The user in your organization assigned to review a document request.
     */
    public val reviewer: kotlin.String? = builder.reviewer
    /**
     * The date and time that a reviewer last updated a response to a document review request.
     */
    public val updatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.ssm.model.DocumentReviewerResponseSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DocumentReviewerResponseSource(")
        append("comment=$comment,")
        append("createTime=$createTime,")
        append("reviewStatus=$reviewStatus,")
        append("reviewer=$reviewer,")
        append("updatedTime=$updatedTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = comment?.hashCode() ?: 0
        result = 31 * result + (this.createTime?.hashCode() ?: 0)
        result = 31 * result + (this.reviewStatus?.hashCode() ?: 0)
        result = 31 * result + (this.reviewer?.hashCode() ?: 0)
        result = 31 * result + (this.updatedTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DocumentReviewerResponseSource

        if (comment != other.comment) return false
        if (createTime != other.createTime) return false
        if (reviewStatus != other.reviewStatus) return false
        if (reviewer != other.reviewer) return false
        if (updatedTime != other.updatedTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.ssm.model.DocumentReviewerResponseSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The comment entered by a reviewer as part of their document review response.
         */
        public var comment: List<DocumentReviewCommentSource>? = null
        /**
         * The date and time that a reviewer entered a response to a document review request.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current review status of a new custom SSM document created by a member of your organization, or of the latest version of an existing SSM document.
         *
         * Only one version of a document can be in the APPROVED state at a time. When a new version is approved, the status of the previous version changes to REJECTED.
         *
         * Only one version of a document can be in review, or PENDING, at a time.
         */
        public var reviewStatus: aws.sdk.kotlin.services.ssm.model.ReviewStatus? = null
        /**
         * The user in your organization assigned to review a document request.
         */
        public var reviewer: kotlin.String? = null
        /**
         * The date and time that a reviewer last updated a response to a document review request.
         */
        public var updatedTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.ssm.model.DocumentReviewerResponseSource) : this() {
            this.comment = x.comment
            this.createTime = x.createTime
            this.reviewStatus = x.reviewStatus
            this.reviewer = x.reviewer
            this.updatedTime = x.updatedTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.ssm.model.DocumentReviewerResponseSource = DocumentReviewerResponseSource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
